/*
 * Copyright (c) MuleSoft, Inc.  All rights reserved.  http://www.mulesoft.com
 * The software in this package is published under the terms of the CPAL v1.0
 * license, a copy of which has been included with this distribution in the
 * LICENSE.txt file.
 */
package org.mule.tests.internal;

import org.mule.metadata.api.model.MetadataType;
import org.mule.runtime.api.metadata.MetadataContext;
import org.mule.runtime.api.metadata.resolving.OutputTypeResolver;
import org.mule.runtime.extension.api.annotation.metadata.OutputResolver;
import org.mule.tests.api.ValueInterceptorContainer;

import java.util.Map;

import javax.inject.Inject;

public class ValueInterceptionOperations {

  @Inject
  private ValueInterceptorContainer container;

  public void interceptValue(String ref, Object value) {
    container.intercept(ref, value);
  }


  @OutputResolver(output = DumpOutputResolver.class)
  public Map<String, Object> dumpInterceptedValues() {
    return container.dump();
  }
  
  public static class DumpOutputResolver implements OutputTypeResolver {

    @Override
    public String getCategoryName() {
      return "dump";
    }

    @Override
    public MetadataType getOutputType(MetadataContext context, Object key) {
      return context.getTypeBuilder().arrayType().of(context.getTypeBuilder().objectType()).build();
    }
  }
}
