/*
 * Copyright (c) MuleSoft, Inc.  All rights reserved.  http://www.mulesoft.com
 * The software in this package is published under the terms of the CPAL v1.0
 * license, a copy of which has been included with this distribution in the
 * LICENSE.txt file.
 */
package org.mule.tests.internal;

import static org.mule.runtime.api.scheduler.SchedulerConfig.config;

import org.mule.runtime.api.lifecycle.Disposable;
import org.mule.runtime.api.lifecycle.Initialisable;
import org.mule.runtime.api.lifecycle.InitialisationException;
import org.mule.runtime.api.scheduler.Scheduler;
import org.mule.runtime.api.scheduler.SchedulerService;
import org.mule.runtime.api.util.LazyValue;
import org.mule.runtime.extension.api.annotation.Configuration;
import org.mule.runtime.extension.api.annotation.Operations;
import org.mule.runtime.extension.api.annotation.param.RefName;

import javax.inject.Inject;

@Configuration(name = "nonBlockingConfig")
@Operations(NonBlockingOperations.class)
public class NonBlockingConfiguration implements Initialisable, Disposable {

  private static int MAX_THREADS = 8;

  @RefName
  private String configName;

  @Inject
  private SchedulerService schedulerService;

  private LazyValue<Scheduler> customScheduler;

  @Override
  public void initialise() throws InitialisationException {
    customScheduler = new LazyValue<>(() -> schedulerService.customScheduler(config()
        .withName("NonBlockingConfiguration[" + configName + "]")
        .withWaitAllowed(true)
        .withMaxConcurrentTasks(MAX_THREADS)));
  }

  @Override
  public void dispose() {
    customScheduler.ifComputed(Scheduler::stop);
  }

  public Scheduler getCustomScheduler() {
    return customScheduler.get();
  }
}
