/*
 * Copyright (c) MuleSoft, Inc.  All rights reserved.  http://www.mulesoft.com
 * The software in this package is published under the terms of the CPAL v1.0
 * license, a copy of which has been included with this distribution in the
 * LICENSE.txt file.
 */
package org.mule.tests.internal;

import static java.util.concurrent.TimeUnit.MILLISECONDS;
import static org.mule.runtime.extension.api.annotation.param.MediaType.ANY;
import static org.slf4j.LoggerFactory.getLogger;

import org.mule.runtime.api.metadata.TypedValue;
import org.mule.runtime.api.scheduler.Scheduler;
import org.mule.runtime.core.api.processor.Processor;
import org.mule.runtime.extension.api.annotation.param.Config;
import org.mule.runtime.extension.api.annotation.param.Content;
import org.mule.runtime.extension.api.annotation.param.MediaType;
import org.mule.runtime.extension.api.annotation.param.Optional;
import org.mule.runtime.extension.api.runtime.operation.Result;
import org.mule.runtime.extension.api.runtime.process.CompletionCallback;

import org.slf4j.Logger;

/**
 * This class is a container for operations, every public method in this class will be taken as an extension operation.
 */
public class NonBlockingOperations {

  private static final Logger LOGGER = getLogger(NonBlockingOperations.class);

  /**
   * Test async non-blocking {@link Processor} implementation that will return control to the Flow in a custom {@link Scheduler}
   * thread in the same way as, for example, a HTTP requester would.
   */
  @MediaType(value = ANY, strict = false)
  public void nonBlocking(@Config NonBlockingConfiguration configuration,
                          @Content(primary = true) @Optional(defaultValue = "#[payload]") TypedValue<Object> content,
                          @Optional Long delayMillis,
                          CompletionCallback<Object, Object> callback) {
    final Runnable command = () -> {
      LOGGER.debug("nonBlocking after");
      callback.success(Result.builder().output(content.getValue()).build());
    };

    LOGGER.debug("nonBlocking before");

    if (delayMillis == null) {
      configuration.getCustomScheduler().execute(command);
    } else {
      configuration.getCustomScheduler().schedule(command, delayMillis, MILLISECONDS);
    }

  }
}
