/*
 * Copyright (c) MuleSoft, Inc.  All rights reserved.  http://www.mulesoft.com
 * The software in this package is published under the terms of the CPAL v1.0
 * license, a copy of which has been included with this distribution in the
 * LICENSE.txt file.
 */
package org.mule.tests.internal;

import static org.mule.runtime.api.metadata.DataType.fromType;

import org.mule.runtime.api.metadata.DataType;
import org.mule.sdk.api.notification.NotificationActionDefinition;

public enum DummyNotificationAction implements NotificationActionDefinition<DummyNotificationAction> {

    INTEGER_NOTIFICATION(fromType(Integer.class)),

    STRING_NOTIFICATION(fromType(String.class));

    private final DataType dataType;

    DummyNotificationAction(DataType dataType) {
        this.dataType = dataType;
    }

    @Override
    public DataType getDataType() {
        return dataType;
    }
}
