/*
 * Decompiled with CFR 0.152.
 */
package org.mule.tests.internal;

import org.mule.runtime.core.api.util.UUID;
import org.mule.runtime.extension.api.annotation.param.MediaType;
import org.mule.runtime.extension.api.annotation.param.Optional;
import org.mule.runtime.extension.api.runtime.process.CompletionCallback;
import org.mule.runtime.extension.api.runtime.route.Chain;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class AssertOperations {
    private static final Logger LOGGER = LoggerFactory.getLogger(AssertOperations.class);
    private static final ThreadLocal<String> taskTokenInThread = new ThreadLocal();

    @MediaType(value="*/*", strict=false)
    public void assertIntercepting(@Optional(defaultValue="true") boolean responseSameTask, Chain interceptedChain, CompletionCallback<Object, Object> callback) {
        String requestTaskToken;
        if (taskTokenInThread.get() != null) {
            requestTaskToken = taskTokenInThread.get();
        } else {
            requestTaskToken = this.generateTaskToken();
            taskTokenInThread.set(requestTaskToken);
        }
        interceptedChain.process(r -> {
            String responseTaskToken = taskTokenInThread.get() != null ? taskTokenInThread.get() : this.generateTaskToken();
            if (responseSameTask && !requestTaskToken.equals(responseTaskToken)) {
                callback.error((Throwable)new IllegalStateException(String.format("Response task (%s) was not same as request task (%s)", responseTaskToken, requestTaskToken)));
            } else if (!responseSameTask && requestTaskToken.equals(responseTaskToken)) {
                IllegalStateException e = new IllegalStateException(String.format("Response task (%s) was same as request task (%s)", responseTaskToken, requestTaskToken));
                LOGGER.error(e.getMessage(), (Throwable)e);
                callback.error((Throwable)e);
            } else {
                callback.success(r);
            }
        }, (t, r) -> callback.error(t));
    }

    private String generateTaskToken() {
        return Thread.currentThread().getName() + " - " + UUID.getUUID();
    }
}

