/*
 * Decompiled with CFR 0.152.
 */
package org.mule.tests.internal;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.function.Predicate;
import javax.inject.Inject;
import org.mule.runtime.api.i18n.I18nMessageFactory;
import org.mule.runtime.api.profiling.ProfilingDataConsumer;
import org.mule.runtime.api.profiling.type.ProfilingEventType;
import org.mule.runtime.api.profiling.type.RuntimeProfilingEventTypes;
import org.mule.runtime.api.profiling.type.context.TransactionProfilingEventContext;
import org.mule.runtime.core.api.transaction.TransactionCoordination;
import org.mule.runtime.core.privileged.profiling.PrivilegedProfilingService;
import org.mule.runtime.extension.api.annotation.param.MediaType;

public class TransactionProfilingConsumptionOperations {
    @Inject
    private PrivilegedProfilingService service;
    private static boolean alreadyAddedConsumers = false;
    private static final Map<String, List<String>> obtainedStates = new HashMap<String, List<String>>();
    private static final ArrayList<Boolean> obtainedActive = new ArrayList();
    private static final ArrayList<String> expectedStates = new ArrayList();
    private static final ArrayList<Boolean> expectedActive = new ArrayList();
    private static final ArrayList<String> expectedAt = new ArrayList();

    @MediaType(value="*/*", strict=false)
    public void startConsumingTransactions() {
        TransactionProfilingConsumptionOperations.clear();
        if (alreadyAddedConsumers) {
            return;
        }
        alreadyAddedConsumers = true;
        this.service.registerProfilingDataConsumer((ProfilingDataConsumer)new ProfilingDataConsumer<TransactionProfilingEventContext>(){

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            public void onProfilingEvent(ProfilingEventType<TransactionProfilingEventContext> profilingEventType, TransactionProfilingEventContext profilingEventContext) {
                Map map = obtainedStates;
                synchronized (map) {
                    if (!obtainedStates.containsKey(Thread.currentThread().toString())) {
                        obtainedStates.put(Thread.currentThread().toString(), new LinkedList());
                    }
                    ((List)obtainedStates.get(Thread.currentThread().toString())).add(profilingEventType.toString());
                }
            }

            public Set<ProfilingEventType<TransactionProfilingEventContext>> getProfilingEventTypes() {
                HashSet<ProfilingEventType<TransactionProfilingEventContext>> events = new HashSet<ProfilingEventType<TransactionProfilingEventContext>>();
                events.add(RuntimeProfilingEventTypes.TX_START);
                events.add(RuntimeProfilingEventTypes.TX_COMMIT);
                events.add(RuntimeProfilingEventTypes.TX_CONTINUE);
                events.add(RuntimeProfilingEventTypes.TX_ROLLBACK);
                return events;
            }

            public Predicate<TransactionProfilingEventContext> getEventContextFilter() {
                return tx -> true;
            }
        });
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @MediaType(value="*/*", strict=false)
    public void addTransactionExpectation(boolean active, String state) {
        ArrayList<String> arrayList = expectedStates;
        synchronized (arrayList) {
            expectedActive.add(active);
            expectedStates.add(state);
            obtainedActive.add(TransactionCoordination.isTransactionActive());
            expectedAt.add(Thread.currentThread().toString());
        }
    }

    private static void clear() {
        obtainedStates.clear();
        obtainedActive.clear();
        expectedStates.clear();
        expectedActive.clear();
        expectedAt.clear();
    }

    private String formattedState(boolean active, String state) {
        return String.format("(active: %b, state: %s)", active, state);
    }

    @MediaType(value="*/*", strict=false)
    public void assertTransactions() {
        int totalStates = obtainedStates.keySet().stream().map(thread -> obtainedStates.get(thread).size()).reduce(0, Integer::sum);
        if (expectedStates.size() != totalStates) {
            throw new AssertionError(I18nMessageFactory.createStaticMessage((String)String.format("Expected %d results, obtained %d", expectedStates.size(), totalStates)));
        }
        for (int i = 0; i < expectedStates.size(); ++i) {
            String runningThread = expectedAt.get(i);
            List<String> eventsInThread = obtainedStates.get(runningThread);
            String nextState = eventsInThread.remove(0);
            if (expectedActive.get(i) != obtainedActive.get(i) || !expectedStates.get(i).equals(nextState)) {
                throw new AssertionError(I18nMessageFactory.createStaticMessage((String)String.format("Error in transaction expectations (number %d). Expected %s, obtained %s", i + 1, this.formattedState(expectedActive.get(i), expectedStates.get(i)), this.formattedState(obtainedActive.get(i), nextState))));
            }
        }
    }
}

