/*
 * Decompiled with CFR 0.152.
 */
package org.mule.tests.api;

import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.TimeUnit;
import org.mule.runtime.core.api.event.CoreEvent;
import org.mule.tests.internal.TestQueue;

public class TestQueueManager {
    private final Map<String, TestQueue> queuesMap = new ConcurrentHashMap<String, TestQueue>();

    public TestQueue get(String configName) {
        return this.queuesMap.computeIfAbsent(configName, TestQueue::new);
    }

    public TestQueue remove(String configName) {
        return this.queuesMap.remove(configName);
    }

    public CoreEvent read(String configName, long timeout, TimeUnit timeUnit) {
        try {
            return this.get(configName).pop(timeout, timeUnit);
        }
        catch (InterruptedException e) {
            Thread.currentThread().interrupt();
            return null;
        }
    }

    public void write(String configName, CoreEvent event) {
        try {
            this.get(configName).push(event);
        }
        catch (InterruptedException e) {
            Thread.currentThread().interrupt();
        }
    }

    public int countPendingEvents(String configName) {
        return this.get(configName).countPendingEvents();
    }
}

