/*
 * Decompiled with CFR 0.152.
 */
package org.mule.test.crafted.config.properties.extension;

import java.util.Optional;
import org.mule.runtime.api.component.location.ComponentLocation;
import org.mule.runtime.config.api.dsl.model.ResourceProvider;
import org.mule.runtime.config.api.dsl.model.properties.ConfigurationProperty;
import org.mule.runtime.config.api.dsl.model.properties.DefaultConfigurationPropertiesProvider;

public class SecureConfigurationPropertiesProvider
extends DefaultConfigurationPropertiesProvider {
    private static final String SECURE_PREFIX = "secure::";
    private final String algorithm;
    private final String mode;

    public SecureConfigurationPropertiesProvider(ResourceProvider resourceProvider, String file, String algorithm, String mode) {
        super(file, resourceProvider);
        this.algorithm = algorithm;
        this.mode = mode;
    }

    public Optional<ConfigurationProperty> getConfigurationProperty(String configurationAttributeKey) {
        if (configurationAttributeKey.startsWith(SECURE_PREFIX)) {
            String effectiveKey = configurationAttributeKey.substring(SECURE_PREFIX.length());
            return Optional.ofNullable(this.configurationAttributes.get(effectiveKey));
        }
        return Optional.empty();
    }

    public String getDescription() {
        ComponentLocation location = (ComponentLocation)this.getAnnotation(LOCATION_KEY);
        return String.format("<secure-configuration-properties file=\"%s\"> - file: %s, line number: %s", this.fileLocation, location.getFileName().orElse("unknown"), location.getLineInFile().map(String::valueOf).orElse("unknown"));
    }

    protected String createValue(String key, String value) {
        return String.format("%s:%s:%s:%s", key, value, this.algorithm, this.mode);
    }
}

