/*
 * Decompiled with CFR 0.152.
 */
package org.mule.test.crafted.config.properties.extension;

import java.util.Optional;
import org.mule.runtime.api.component.location.ComponentLocation;
import org.mule.runtime.api.lifecycle.Disposable;
import org.mule.runtime.api.lifecycle.Initialisable;
import org.mule.runtime.api.lifecycle.InitialisationException;
import org.mule.runtime.config.api.dsl.model.ResourceProvider;
import org.mule.runtime.config.api.dsl.model.properties.ConfigurationProperty;
import org.mule.runtime.config.api.dsl.model.properties.DefaultConfigurationPropertiesProvider;

public class SecureConfigurationPropertiesProvider
extends DefaultConfigurationPropertiesProvider
implements Initialisable,
Disposable {
    private static final String SECURE_PREFIX = "secure::";
    private static final String LIFECYCLE_PREFIX = "lifecycle::";
    private final String algorithm;
    private final String mode;
    private int initializationCount = 0;
    private int disposeCount = 0;

    public SecureConfigurationPropertiesProvider(ResourceProvider resourceProvider, String file, String algorithm, String mode) {
        super(file, resourceProvider);
        this.algorithm = algorithm;
        this.mode = mode;
    }

    public void initialise() throws InitialisationException {
        super.initialise();
        ++this.initializationCount;
    }

    public void dispose() {
        ++this.disposeCount;
    }

    public Optional<ConfigurationProperty> getConfigurationProperty(String configurationAttributeKey) {
        if (configurationAttributeKey.startsWith(SECURE_PREFIX)) {
            String effectiveKey = configurationAttributeKey.substring(SECURE_PREFIX.length());
            return Optional.ofNullable(this.configurationAttributes.get(effectiveKey));
        }
        if (configurationAttributeKey.startsWith(LIFECYCLE_PREFIX)) {
            final String effectiveKey = configurationAttributeKey.substring(LIFECYCLE_PREFIX.length());
            if ("initialize".equals(effectiveKey) || "dispose".equals(effectiveKey)) {
                return Optional.of(new ConfigurationProperty(){

                    public Object getSource() {
                        return this;
                    }

                    public Object getRawValue() {
                        return "initialize".equals(effectiveKey) ? Integer.toString(SecureConfigurationPropertiesProvider.this.initializationCount) : Integer.toString(SecureConfigurationPropertiesProvider.this.disposeCount);
                    }

                    public String getKey() {
                        return effectiveKey;
                    }
                });
            }
            return Optional.empty();
        }
        return Optional.empty();
    }

    public String getDescription() {
        ComponentLocation location = (ComponentLocation)this.getAnnotation(LOCATION_KEY);
        return String.format("<secure-configuration-properties file=\"%s\"> - file: %s, line number: %s", this.fileLocation, location.getFileName().orElse("unknown"), location.getLineInFile().map(String::valueOf).orElse("unknown"));
    }

    protected String createValue(String key, String value) {
        return String.format("%s:%s:%s:%s", key, value, this.algorithm, this.mode);
    }
}

