/*
 * Decompiled with CFR 0.152.
 */
package com.mulesoft.telemetry;

import com.mulesoft.telemetry.TelemetryService;
import java.time.Clock;
import java.time.Instant;

public abstract class AbstractTelemetryService
implements TelemetryService {
    private final Clock clock;
    private boolean started;
    private boolean shutdown;

    public AbstractTelemetryService(Clock clock) {
        this.clock = clock;
    }

    @Override
    public final void emit(Object data) throws IllegalArgumentException {
        if (data == null) {
            throw new IllegalArgumentException("The event argument shouldn't be null");
        }
        this.emit(this.eventTypeFromClass(data.getClass()), data);
    }

    protected String eventTypeFromClass(Class<?> clazz) {
        return clazz.getSimpleName().replaceAll("([a-z])([A-Z])", "$1-$2").toLowerCase();
    }

    protected Instant timeStamp() {
        return this.clock.instant();
    }

    @Override
    public final void start() {
        if (this.isShutdown()) {
            throw new IllegalStateException("The service is shutdown");
        }
        if (!this.isStarted()) {
            this.started = true;
            this.startWhenNotStarted();
        }
    }

    @Override
    public final boolean isStarted() {
        return this.started;
    }

    protected abstract void startWhenNotStarted();

    @Override
    public final void shutdown() {
        if (!this.isShutdown() && this.isStarted()) {
            this.shutdownWhenStarted();
        }
        this.shutdown = true;
        this.started = false;
    }

    @Override
    public final boolean isShutdown() {
        return this.shutdown;
    }

    protected abstract void shutdownWhenStarted();
}

