/*
 * Decompiled with CFR 0.152.
 */
package com.mulesoft.telemetry;

import com.google.gson.FieldNamingStrategy;
import com.google.gson.Gson;
import com.google.gson.GsonBuilder;
import com.google.gson.JsonDeserializationContext;
import com.google.gson.JsonDeserializer;
import com.google.gson.JsonElement;
import com.google.gson.JsonParseException;
import com.google.gson.JsonPrimitive;
import com.google.gson.JsonSerializationContext;
import com.google.gson.JsonSerializer;
import com.mulesoft.telemetry.Event;
import com.mulesoft.telemetry.EventBundle;
import com.mulesoft.telemetry.SendBundleException;
import com.mulesoft.telemetry.SessionInformation;
import com.mulesoft.telemetry.TelemetryClient;
import java.io.IOException;
import java.lang.reflect.Field;
import java.lang.reflect.Type;
import java.net.URI;
import java.time.Instant;
import org.apache.http.HttpEntity;
import org.apache.http.HttpHost;
import org.apache.http.auth.AuthScheme;
import org.apache.http.auth.AuthScope;
import org.apache.http.auth.Credentials;
import org.apache.http.auth.UsernamePasswordCredentials;
import org.apache.http.client.AuthCache;
import org.apache.http.client.CredentialsProvider;
import org.apache.http.client.methods.CloseableHttpResponse;
import org.apache.http.client.methods.HttpPost;
import org.apache.http.client.methods.HttpUriRequest;
import org.apache.http.client.protocol.HttpClientContext;
import org.apache.http.entity.ContentType;
import org.apache.http.entity.StringEntity;
import org.apache.http.impl.auth.BasicScheme;
import org.apache.http.impl.client.BasicAuthCache;
import org.apache.http.impl.client.BasicCredentialsProvider;
import org.apache.http.impl.client.CloseableHttpClient;
import org.apache.http.impl.client.HttpClients;
import org.apache.http.protocol.HttpContext;

public class TelemetryHttpClient
implements TelemetryClient {
    private final Gson gson;
    private final URI endpoint;
    private final CloseableHttpClient httpClient;
    private final HttpClientContext clientContext;

    public static TelemetryHttpClient usingBasicAuthentication(String username, String password, URI endpoint) {
        BasicCredentialsProvider credentialsProvider = new BasicCredentialsProvider();
        credentialsProvider.setCredentials(new AuthScope(endpoint.getHost(), endpoint.getPort(), AuthScope.ANY_REALM, AuthScope.ANY_SCHEME), (Credentials)new UsernamePasswordCredentials(username, password));
        CloseableHttpClient httpClient = HttpClients.custom().setDefaultCredentialsProvider((CredentialsProvider)credentialsProvider).build();
        BasicAuthCache authCache = new BasicAuthCache();
        HttpHost httpHost = new HttpHost(endpoint.getHost(), endpoint.getPort(), endpoint.getScheme());
        authCache.put(httpHost, (AuthScheme)new BasicScheme());
        HttpClientContext context = HttpClientContext.create();
        context.setAuthCache((AuthCache)authCache);
        return new TelemetryHttpClient(endpoint, httpClient, context);
    }

    public TelemetryHttpClient(URI endpoint) {
        this(endpoint, HttpClients.createDefault(), null);
    }

    public TelemetryHttpClient(URI endpoint, CloseableHttpClient httpClient, HttpClientContext clientContext) {
        this.endpoint = endpoint;
        this.httpClient = httpClient;
        this.gson = new GsonBuilder().registerTypeAdapter(Instant.class, (Object)new InstantAdapter()).setDateFormat("yyyy-MM-dd'T'HH:mm:ss.SSSX").setFieldNamingStrategy((FieldNamingStrategy)new ShortFieldNames()).create();
        this.clientContext = clientContext;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void send(EventBundle bundle) throws SendBundleException {
        HttpPost post = new HttpPost(this.endpoint);
        CloseableHttpResponse response = null;
        try {
            try {
                post.setEntity((HttpEntity)new StringEntity(this.gson.toJson((Object)bundle), ContentType.APPLICATION_JSON));
                response = this.httpClient.execute((HttpUriRequest)post, (HttpContext)this.clientContext);
            }
            catch (Exception e) {
                throw new SendBundleException("HTTP POST failed", e);
            }
            if (response.getStatusLine().getStatusCode() >= 400) {
                throw new SendBundleException("Error response from POST to " + this.endpoint + ". Status: (" + response.getStatusLine().getStatusCode() + ") " + response.getStatusLine().getReasonPhrase());
            }
        }
        finally {
            if (response != null) {
                try {
                    response.close();
                }
                catch (IOException e) {
                    throw new SendBundleException("Failed to close the HTTP connection", e);
                }
            }
        }
    }

    private static class ShortFieldNames
    implements FieldNamingStrategy {
        private ShortFieldNames() {
        }

        public String translateName(Field f) {
            String fieldName = f.getName();
            Class<?> declaringClass = f.getDeclaringClass();
            if (EventBundle.class.equals(declaringClass)) {
                if ("session".equals(fieldName)) {
                    return "s";
                }
                if ("events".equals(fieldName)) {
                    return "e";
                }
            }
            if (Event.class.equals(declaringClass)) {
                if ("timeStamp".equals(fieldName)) {
                    return "ts";
                }
                if ("type".equals(fieldName)) {
                    return "t";
                }
                if ("data".equals(fieldName)) {
                    return "d";
                }
            }
            if (SessionInformation.class.equals(declaringClass)) {
                if ("osName".equals(fieldName)) {
                    return "osn";
                }
                if ("osVersion".equals(fieldName)) {
                    return "osv";
                }
                if ("javaVersion".equals(fieldName)) {
                    return "j";
                }
                if ("productName".equals(fieldName)) {
                    return "pn";
                }
                if ("productVersion".equals(fieldName)) {
                    return "pv";
                }
            }
            return fieldName;
        }
    }

    private static class InstantAdapter
    implements JsonSerializer<Instant>,
    JsonDeserializer<Instant> {
        private InstantAdapter() {
        }

        public Instant deserialize(JsonElement json, Type typeOfT, JsonDeserializationContext context) throws JsonParseException {
            return Instant.parse(json.getAsString());
        }

        public JsonElement serialize(Instant src, Type typeOfSrc, JsonSerializationContext context) {
            return new JsonPrimitive(src.toString());
        }
    }
}

