/*
 * Decompiled with CFR 0.152.
 */
package com.mulesoft.telemetry;

import com.mulesoft.telemetry.AbstractTelemetryService;
import com.mulesoft.telemetry.Event;
import com.mulesoft.telemetry.EventBundle;
import com.mulesoft.telemetry.SessionInformation;
import com.mulesoft.telemetry.TelemetryCallback;
import com.mulesoft.telemetry.TelemetryClient;
import com.mulesoft.telemetry.TelemetryHttpClient;
import java.net.URI;
import java.time.Clock;
import java.time.Instant;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashSet;
import java.util.List;
import java.util.ListIterator;
import java.util.Set;
import java.util.concurrent.BlockingDeque;
import java.util.concurrent.Executors;
import java.util.concurrent.LinkedBlockingDeque;
import java.util.concurrent.ScheduledExecutorService;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.atomic.AtomicLong;
import java.util.concurrent.atomic.AtomicReference;

public class DefaultTelemetryService
extends AbstractTelemetryService {
    private static final int DEFAULT_QUEUE_SIZE = 12000;
    private static final long DEFAULT_SEND_DELAY = 5L;
    private static final TimeUnit DEFAULT_SEND_DELAY_TIMEUNIT = TimeUnit.MINUTES;
    private static final TelemetryCallback DEFAULT_CALLBACK = new TelemetryCallback(){};
    private final BlockingDeque<Event> eventQueue;
    private final TelemetryClient client;
    private SessionInformation sessionInformation;
    private final ScheduledExecutorService executor;
    private final long delay;
    private final TimeUnit timeUnit;
    private final TelemetryCallback callback;
    private final Set<EventBundle> inFlight = Collections.synchronizedSet(new HashSet());
    private final AtomicReference<Instant> firstEventLostTimestamp = new AtomicReference<Object>(null);
    private final AtomicLong eventsLost = new AtomicLong(0L);

    public DefaultTelemetryService(String productName, String productVersion, URI endpoint, String userId, String deviceId) {
        this(Clock.systemUTC(), new LinkedBlockingDeque<Event>(12000), new TelemetryHttpClient(endpoint), new SessionInformation(userId, productName, productVersion, deviceId), Executors.newSingleThreadScheduledExecutor(), 5L, DEFAULT_SEND_DELAY_TIMEUNIT, DEFAULT_CALLBACK);
    }

    public DefaultTelemetryService(String productName, String productVersion, String user, String password, URI endpoint, String userId, String deviceId) {
        this(Clock.systemUTC(), new LinkedBlockingDeque<Event>(12000), TelemetryHttpClient.usingBasicAuthentication(user, password, endpoint), new SessionInformation(userId, productName, productVersion, deviceId), Executors.newSingleThreadScheduledExecutor(), 5L, DEFAULT_SEND_DELAY_TIMEUNIT, DEFAULT_CALLBACK);
    }

    public DefaultTelemetryService(Clock clock, BlockingDeque<Event> eventQueue, TelemetryClient client, SessionInformation sessionInformation, ScheduledExecutorService executor, long delay, TimeUnit timeUnit) {
        super(clock);
        this.eventQueue = eventQueue;
        this.client = client;
        this.sessionInformation = sessionInformation;
        this.executor = executor;
        this.delay = delay;
        this.timeUnit = timeUnit;
        this.callback = DEFAULT_CALLBACK;
    }

    public DefaultTelemetryService(Clock clock, BlockingDeque<Event> eventQueue, TelemetryClient client, SessionInformation sessionInformation, ScheduledExecutorService executor, long delay, TimeUnit timeUnit, TelemetryCallback callback) {
        super(clock);
        this.eventQueue = eventQueue;
        this.client = client;
        this.sessionInformation = sessionInformation;
        this.executor = executor;
        this.delay = delay;
        this.timeUnit = timeUnit;
        this.callback = callback;
    }

    private void sendEvents() {
        if (this.eventQueue.isEmpty()) {
            return;
        }
        long lost = this.eventsLost.getAndSet(0L);
        ArrayList<Event> events = new ArrayList<Event>(this.eventQueue.size() + (lost > 0L ? 1 : 0));
        this.eventQueue.drainTo(events);
        if (lost > 0L) {
            events.add(this.createEventQueueFullEvent(this.firstEventLostTimestamp.getAndSet(null), lost));
        }
        this.send(this.sessionInformation, events);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void send(SessionInformation session, List<Event> events) {
        EventBundle bundle = new EventBundle(session, events);
        this.inFlight.add(bundle);
        try {
            this.client.send(bundle);
            this.callback.onSuccess(bundle);
        }
        catch (Exception e) {
            this.callback.onError(e, bundle);
            this.putBack(bundle);
        }
        finally {
            this.inFlight.remove(bundle);
        }
    }

    private Event createEventQueueFullEvent(Instant lostTimestamp, long lost) {
        return new Event(lostTimestamp, "event-queue-full", Collections.singletonMap("lost", lost));
    }

    private void putBack(EventBundle bundle) {
        ListIterator<Event> iterator = bundle.events().listIterator(bundle.events().size());
        while (iterator.hasPrevious()) {
            Event event = iterator.previous();
            if (this.eventQueue.offerFirst(event)) continue;
            this.registerEventLost(event.timeStamp());
        }
    }

    @Override
    public void emit(String type, Object data) throws IllegalStateException {
        if (!this.isStarted()) {
            throw new IllegalStateException("The telemetry service is not started");
        }
        if (!this.eventQueue.offer(new Event(this.timeStamp(), type, data))) {
            this.registerEventLost(this.timeStamp());
        }
    }

    @Override
    public void updateSessionInformation(String userId) {
        SessionInformation newSession = new SessionInformation(userId, this.sessionInformation.osName(), this.sessionInformation.osVersion(), this.sessionInformation.javaVersion(), this.sessionInformation.productName(), this.sessionInformation.productVersion(), this.sessionInformation.deviceId(), this.sessionInformation.sessionId());
        this.setSessionInformation(newSession);
    }

    private void registerEventLost(Instant lostTimeStamp) {
        this.firstEventLostTimestamp.compareAndSet(null, lostTimeStamp);
        this.eventsLost.incrementAndGet();
    }

    private void sendAllPendingEvents() {
        for (EventBundle bundle : this.inFlight) {
            this.putBack(bundle);
        }
        this.sendEvents();
    }

    @Override
    protected void startWhenNotStarted() {
        this.executor.scheduleWithFixedDelay(this::sendEvents, this.delay, this.delay, this.timeUnit);
    }

    @Override
    public void shutdownWhenStarted() {
        this.executor.shutdownNow();
        this.sendAllPendingEvents();
    }

    private void setSessionInformation(SessionInformation session) {
        this.sessionInformation = session;
    }

    private SessionInformation sessionInformation() {
        return this.sessionInformation;
    }

    static /* synthetic */ TimeUnit access$000() {
        return DEFAULT_SEND_DELAY_TIMEUNIT;
    }

    static /* synthetic */ TelemetryCallback access$100() {
        return DEFAULT_CALLBACK;
    }

    public static class Builder {
        private Clock clock = Clock.systemUTC();
        private BlockingDeque<Event> eventQueue = new LinkedBlockingDeque<Event>(12000);
        private ScheduledExecutorService executor = Executors.newSingleThreadScheduledExecutor();
        private long delay = 5L;
        private TimeUnit timeUnit = DefaultTelemetryService.access$000();
        private TelemetryClient client;
        private String username;
        private String password;
        private URI endpointUri;
        private String productName;
        private String productVersion;
        private TelemetryCallback callback = DefaultTelemetryService.access$100();
        private String userId;
        private String deviceId;

        public Builder withClock(Clock clock) {
            this.clock = clock;
            return this;
        }

        public Builder withEventQueue(BlockingDeque<Event> eventQueue) {
            this.eventQueue = eventQueue;
            return this;
        }

        public Builder withExecutor(ScheduledExecutorService executor) {
            this.executor = executor;
            return this;
        }

        public Builder withDelay(long delay) {
            this.delay = delay;
            return this;
        }

        public Builder withDelay(long delay, TimeUnit timeUnit) {
            this.delay = delay;
            this.timeUnit = timeUnit;
            return this;
        }

        public Builder withUsername(String username) {
            this.username = username;
            return this;
        }

        public Builder withPassword(String password) {
            this.password = password;
            return this;
        }

        public Builder withEndpointUri(URI endpointUri) {
            this.endpointUri = endpointUri;
            return this;
        }

        public Builder withTelemetryClient(TelemetryClient telemetryClient) {
            this.client = telemetryClient;
            return this;
        }

        public Builder withProductName(String productName) {
            this.productName = productName;
            return this;
        }

        public Builder withProductVersion(String productVersion) {
            this.productVersion = productVersion;
            return this;
        }

        public Builder withCallback(TelemetryCallback callback) {
            this.callback = callback;
            return this;
        }

        public Builder withUserId(String userId) {
            this.userId = userId;
            return this;
        }

        public Builder withDeviceId(String deviceId) {
            this.deviceId = deviceId;
            return this;
        }

        public DefaultTelemetryService build() {
            if (this.endpointUri == null) {
                throw new IllegalArgumentException("endpointUri is mandatory");
            }
            if (this.productName == null) {
                throw new IllegalArgumentException("productName is mandatory");
            }
            if (this.productVersion == null) {
                throw new IllegalArgumentException("productVersion is mandatory");
            }
            if (this.client == null) {
                this.client = this.username != null ? TelemetryHttpClient.usingBasicAuthentication(this.username, this.password, this.endpointUri) : new TelemetryHttpClient(this.endpointUri);
            }
            return new DefaultTelemetryService(this.clock, this.eventQueue, this.client, new SessionInformation(this.userId, this.productName, this.productVersion, this.deviceId), this.executor, this.delay, this.timeUnit, this.callback);
        }
    }
}

