/*
 * Decompiled with CFR 0.152.
 */
package com.install4j.runtime.beans.actions.services;

import com.exe4j.runtime.util.FileUtil;
import com.install4j.api.Util;
import com.install4j.api.beans.PropertyLoggingInterceptor;
import com.install4j.api.context.Context;
import com.install4j.api.context.InstallerContext;
import com.install4j.api.context.ProgressInterface;
import com.install4j.api.context.UninstallerContext;
import com.install4j.api.context.UserCanceledException;
import com.install4j.api.unix.UnixFileSystem;
import com.install4j.api.windows.RegistryRoot;
import com.install4j.api.windows.WinRegistry;
import com.install4j.api.windows.WinUser;
import com.install4j.runtime.beans.actions.SystemAutoUninstallInstallAction;
import com.install4j.runtime.beans.actions.services.ServiceAccount;
import com.install4j.runtime.beans.actions.services.WindowsPriority;
import com.install4j.runtime.installer.AbstractRemoteCallable;
import com.install4j.runtime.installer.frontend.Messages;
import com.install4j.runtime.installer.helper.InstallerUtil;
import com.install4j.runtime.installer.helper.Logger;
import com.install4j.runtime.installer.helper.comm.ExecutionContext;
import com.install4j.runtime.installer.helper.fileinst.FileInstaller;
import com.install4j.runtime.installer.helper.launching.LaunchDescriptor;
import com.install4j.runtime.installer.helper.launching.LaunchHelper;
import com.install4j.runtime.installer.platform.unix.Execution;
import com.install4j.runtime.installer.platform.win32.Win32Services;
import com.install4j.runtime.installer.platform.win32.Win32UserInfo;
import java.io.File;
import java.io.FileOutputStream;
import java.io.FileWriter;
import java.io.IOException;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.io.PrintWriter;
import java.io.Serializable;
import java.text.MessageFormat;
import java.util.ArrayList;
import java.util.List;
import java.util.Properties;
import java.util.StringTokenizer;

public class InstallServiceAction
extends SystemAutoUninstallInstallAction
implements PropertyLoggingInterceptor {
    private String launcherId = "";
    private File executable;
    private String serviceName;
    private boolean autoStart = true;
    private String description = "";
    private String windowsDependencies = "";
    private String macosIdentifier = "";
    private String windowsArguments = "";
    private boolean restartOnFailure;
    private boolean interactive;
    private WindowsPriority windowsPriority = WindowsPriority.NORMAL_PRIORITY_CLASS;
    private ServiceAccount serviceAccount = ServiceAccount.LOCAL_SYSTEM;
    private String accountNameOrSid = "";
    private String password = "";
    private boolean keepCurrentAccount = false;
    private static final String PROP_SERVICE_PATH = "servicePath";
    private static final String PROP_SERVICE_NAME = "serviceName";
    private static final String PROP_STARTUP_TYPE = "startupType";
    private static final String PROP_IDENTIFIER = "identifier";
    private static final String STARTUP_ITEMS_FILE_NAME = "/Library/StartupItems";
    public static final String LAUNCH_DAEMONS_FILE_NAME = "/Library/LaunchDaemons";
    private static final String STARTUP_PARAMETERS_PLIST_NAME = "StartupParameters.plist";
    private static final String REGKEY_PRIORITY = "SOFTWARE\\ej-technologies\\exe4j\\priority";
    private static List installedServices = new ArrayList();

    public static List getInstalledServices() {
        return installedServices;
    }

    private String getUsedPassword() {
        if (this.serviceAccount == ServiceAccount.OTHER) {
            return this.getPassword();
        }
        return "";
    }

    private String getAccountNameOrSidForPrivileges() {
        if (this.serviceAccount == ServiceAccount.OTHER) {
            return this.getAccountNameOrSid();
        }
        return null;
    }

    private String getUsedAccountName() {
        if (this.serviceAccount == ServiceAccount.OTHER) {
            String string = WinUser.getAccountName(this.getAccountNameOrSid());
            if (string != null) {
                return string;
            }
            return this.getAccountNameOrSid();
        }
        return this.serviceAccount.getAccountName();
    }

    public boolean install(InstallerContext installerContext) throws UserCanceledException {
        Serializable serializable;
        Object object;
        File file;
        String string;
        if (Util.isWindows9X()) {
            return true;
        }
        ProgressInterface progressInterface = installerContext.getProgressInterface();
        progressInterface.setDetailMessage("");
        if (this.getLauncherId() == null) {
            string = this.getServiceName();
            file = installerContext.getDestinationFile(this.getExecutable());
        } else {
            object = installerContext.getLauncherById(this.getLauncherId());
            if (object == null) {
                return false;
            }
            file = installerContext.getDestinationFile(object.getRelativeFileName());
            string = object.getName();
        }
        if (!file.exists()) {
            return false;
        }
        object = null;
        String string2 = file.getAbsolutePath();
        try {
            if (InstallerUtil.isWindows()) {
                if (string2.indexOf(32) > -1) {
                    string2 = "\"" + string2 + "\"";
                }
                if (this.getWindowsArguments() != null && this.getWindowsArguments().trim().length() > 0) {
                    string2 = string2 + " " + this.getWindowsArguments().trim();
                }
                if ((serializable = installerContext.runElevated(new InstallWindowsRemoteCallable(string, string2, this.interactive, this.autoStart, this.keepCurrentAccount, this.getWindowsDependencies(), this.getUsedAccountName(), this.getUsedPassword(), this.getAccountNameOrSidForPrivileges(), this.getDescription(), this.getWindowsPriority().getValue(), this.restartOnFailure), true)) instanceof Win32Services.ServiceException) {
                    throw (Win32Services.ServiceException)serializable;
                }
            } else if (InstallerUtil.isMacOS()) {
                object = this.getMacosIdentifier();
                if (object == null || ((String)object).trim().length() == 0) {
                    object = "com.install4j." + installerContext.getApplicationId() + "." + file.getName();
                    Logger.getInstance().info(this, "Using fallback identifier: " + (String)object);
                }
                if ((serializable = installerContext.runElevated(new InstallMacosRemoteCallable(file, string, (String)object, this.autoStart), false)) instanceof IOException) {
                    throw (IOException)serializable;
                }
            } else {
                this.installUnix(file);
            }
        }
        catch (Win32Services.ServiceException serviceException) {
            if (serviceException.getErrorCode() == 1057) {
                Logger.getInstance().error(this, "Invalid service account.");
            } else if (serviceException.getErrorCode() == 5) {
                Logger.getInstance().error(this, "Access denied. Need to be elevated administrator.");
            } else if (serviceException.getErrorCode() == 1060) {
                Logger.getInstance().error(this, "Service does not exist.");
            } else if (serviceException.getErrorCode() == 1069) {
                Logger.getInstance().error(this, "Logon to service account failed. Password is wrong or user does not have log on as service privilege.");
            } else {
                Logger.getInstance().log(serviceException);
            }
            progressInterface.showFailure(MessageFormat.format(Messages.getMessages().getString("ErrorInstallService"), string) + (serviceException.getMessage() != null ? "\n\n" + serviceException.getMessage() : ""));
            return false;
        }
        catch (Exception exception) {
            progressInterface.showFailure(MessageFormat.format(Messages.getMessages().getString("ErrorInstallService"), string) + (exception.getMessage() != null ? "\n\n" + exception.getMessage() : ""));
            Logger.getInstance().log(exception);
            return false;
        }
        serializable = this.getPersistentProperties();
        ((Properties)serializable).setProperty(PROP_SERVICE_PATH, string2);
        ((Properties)serializable).setProperty(PROP_SERVICE_NAME, string);
        ((Properties)serializable).setProperty(PROP_STARTUP_TYPE, this.autoStart ? "auto" : "manual");
        if (object != null) {
            ((Properties)serializable).setProperty(PROP_IDENTIFIER, (String)object);
        }
        installedServices.add(new Info(file.getAbsolutePath(), string, (String)object));
        return true;
    }

    public void rollback(InstallerContext installerContext) {
        this.doUninstallation(installerContext);
    }

    public boolean uninstall(UninstallerContext uninstallerContext) {
        return this.doUninstallation(uninstallerContext);
    }

    private boolean doUninstallation(Context context) {
        Properties properties = this.getPersistentProperties();
        String string = properties.getProperty(PROP_SERVICE_NAME);
        if (string == null) {
            return true;
        }
        try {
            if (InstallerUtil.isWindows()) {
                Serializable serializable = context.runElevated(new UninstallWindowsRemoteCallable(string, properties.getProperty(PROP_SERVICE_PATH)), true);
                if (serializable instanceof Win32Services.ServiceException) {
                    throw (Win32Services.ServiceException)serializable;
                }
            } else if (InstallerUtil.isMacOS()) {
                String string2 = properties.getProperty(PROP_SERVICE_PATH);
                if (string2 == null) {
                    return true;
                }
                File file = new File(string2);
                if (!file.exists()) {
                    return true;
                }
                String string3 = properties.getProperty(PROP_STARTUP_TYPE);
                String string4 = properties.getProperty(PROP_IDENTIFIER);
                context.runElevated(new UninstallMacosRemoteCallable(file, string, string4, string3), true);
            }
            return true;
        }
        catch (Win32Services.ServiceException serviceException) {
            Logger.getInstance().log(serviceException);
        }
        catch (Exception exception) {
            Logger.getInstance().log(exception);
        }
        ProgressInterface progressInterface = context.getProgressInterface();
        progressInterface.showFailure(MessageFormat.format(Messages.getMessages().getString("ErrorUninstallService"), string));
        return true;
    }

    public void installUnix(File file) throws IOException {
        File file2 = new File("/etc/init.d", file.getName());
        if (UnixFileSystem.createLink(file.getAbsolutePath(), file2)) {
            FileInstaller.getInstance().registerUninstallFile(file2);
        }
    }

    private static String formatRequires(String string) {
        StringBuffer stringBuffer = new StringBuffer();
        StringTokenizer stringTokenizer = new StringTokenizer(string, ",");
        while (stringTokenizer.hasMoreTokens()) {
            stringBuffer.append("\"");
            stringBuffer.append(stringTokenizer.nextToken().trim());
            stringBuffer.append("\"");
            if (!stringTokenizer.hasMoreTokens()) continue;
            stringBuffer.append(", ");
        }
        return stringBuffer.toString();
    }

    public String getServiceName() {
        return InstallServiceAction.replaceVariables(this.serviceName);
    }

    public void setServiceName(String string) {
        this.serviceName = string;
    }

    public boolean isAutoStart() {
        return this.autoStart;
    }

    public void setAutoStart(boolean bl) {
        this.autoStart = bl;
    }

    public File getExecutable() {
        return InstallServiceAction.replaceVariables(this.executable);
    }

    public void setExecutable(File file) {
        this.executable = file;
    }

    public String getWindowsArguments() {
        return InstallServiceAction.replaceVariables(this.windowsArguments);
    }

    public void setWindowsArguments(String string) {
        this.windowsArguments = string;
    }

    public String getLauncherId() {
        return this.launcherId;
    }

    public void setLauncherId(String string) {
        this.launcherId = string;
    }

    public String getDescription() {
        return InstallServiceAction.replaceVariables(this.description);
    }

    public void setDescription(String string) {
        this.description = string;
    }

    public String getWindowsDependencies() {
        return InstallServiceAction.replaceVariables(this.windowsDependencies);
    }

    public void setWindowsDependencies(String string) {
        this.windowsDependencies = string;
    }

    public String getMacosIdentifier() {
        return InstallServiceAction.replaceVariables(this.macosIdentifier);
    }

    public void setMacosIdentifier(String string) {
        this.macosIdentifier = string;
    }

    public boolean isRestartOnFailure() {
        return this.restartOnFailure;
    }

    public void setRestartOnFailure(boolean bl) {
        this.restartOnFailure = bl;
    }

    public boolean isInteractive() {
        return this.interactive;
    }

    public void setInteractive(boolean bl) {
        this.interactive = bl;
    }

    public String getAccountNameOrSid() {
        return InstallServiceAction.replaceVariables(this.accountNameOrSid);
    }

    public void setAccountNameOrSid(String string) {
        this.accountNameOrSid = string;
    }

    public String getPassword() {
        return InstallServiceAction.replaceVariables(this.password);
    }

    public void setPassword(String string) {
        this.password = string;
    }

    public ServiceAccount getServiceAccount() {
        return this.serviceAccount;
    }

    public void setServiceAccount(ServiceAccount serviceAccount) {
        this.serviceAccount = serviceAccount;
    }

    public boolean isKeepCurrentAccount() {
        return this.keepCurrentAccount;
    }

    public void setKeepCurrentAccount(boolean bl) {
        this.keepCurrentAccount = bl;
    }

    public WindowsPriority getWindowsPriority() {
        return this.windowsPriority;
    }

    public void setWindowsPriority(WindowsPriority windowsPriority) {
        this.windowsPriority = windowsPriority;
    }

    public Object getLogValueForProperty(String string, Object object) {
        if (string.equals("password") && !Boolean.getBoolean("install4j.logServicePassword")) {
            return "[logging of password is disabled]";
        }
        return object;
    }

    public static class Info {
        private String executable;
        private String serviceName;
        private String macosIdentifier;

        public Info(String string, String string2, String string3) {
            this.executable = string;
            this.serviceName = string2;
            this.macosIdentifier = string3;
        }

        public String getExecutable() {
            return this.executable;
        }

        public void setExecutable(String string) {
            this.executable = string;
        }

        public String getServiceName() {
            return this.serviceName;
        }

        public void setServiceName(String string) {
            this.serviceName = string;
        }

        public String getMacosIdentifier() {
            return this.macosIdentifier;
        }
    }

    private static class InstallMacosRemoteCallable
    extends AbstractRemoteCallable {
        File execFile;
        String name;
        String identifier;
        private boolean autoStart;

        private InstallMacosRemoteCallable(File file, String string, String string2, boolean bl) {
            this.execFile = file;
            this.name = string;
            this.identifier = string2;
            this.autoStart = bl;
        }

        public Serializable execute() {
            if (!this.execFile.exists()) {
                return null;
            }
            try {
                if (System.getProperty("os.version").compareTo("10.4") >= 0) {
                    File file = new File(InstallServiceAction.STARTUP_ITEMS_FILE_NAME, this.name);
                    FileUtil.deleteDirectory(file);
                    this.createLaunchDaemon();
                } else if (this.autoStart) {
                    this.createStartupItem();
                }
            }
            catch (IOException iOException) {
                return iOException;
            }
            return null;
        }

        private void createLaunchDaemon() throws IOException {
            File file = new File(InstallServiceAction.LAUNCH_DAEMONS_FILE_NAME, this.identifier + ".plist");
            PrintWriter printWriter = new PrintWriter(new OutputStreamWriter((OutputStream)new FileOutputStream(file), "UTF-8"));
            printWriter.println("<?xml version=\"1.0\" encoding=\"UTF-8\"?>\n<!DOCTYPE plist PUBLIC \"-//Apple Computer//DTD PLIST 1.0//EN\" \"http://www.apple.com/DTDs/PropertyList-1.0.dtd\">\n<plist version=\"1.0\">\n<dict>\n    <key>Label</key>\n    <string>" + this.identifier + "</string>\n" + "    <key>ProgramArguments</key>\n" + "    <array>\n" + "        <string>" + this.execFile.getCanonicalPath() + "</string>\n" + "        <string>start-launchd</string>\n" + "    </array>\n" + "    <key>OnDemand</key>\n" + "    <true/>\n" + "    <key>RunAtLoad</key>\n" + "    <" + this.autoStart + "/>\n" + "</dict>\n" + "</plist>");
            printWriter.close();
            UnixFileSystem.setMode("644", file);
        }

        public void createStartupItem() throws IOException {
            File file = new File(InstallServiceAction.STARTUP_ITEMS_FILE_NAME, this.name);
            file.mkdirs();
            FileUtil.emptyDirectory(file);
            File file2 = new File(file, this.name);
            PrintWriter printWriter = new PrintWriter(new FileWriter(file2));
            printWriter.println("#! /bin/sh");
            printWriter.println("\"" + this.execFile.getAbsolutePath() + "\" $@");
            printWriter.close();
            UnixFileSystem.setMode(493, file2);
            File file3 = new File(file, InstallServiceAction.STARTUP_PARAMETERS_PLIST_NAME);
            printWriter = new PrintWriter(new FileWriter(file3));
            printWriter.println("{");
            printWriter.println("  Description     = \"" + this.name + "\";");
            printWriter.println("  Provides        = (\"" + this.name + "\");");
            printWriter.println("  Requires        = (" + InstallServiceAction.formatRequires(this.identifier) + ");");
            printWriter.println("  OrderPreference = \"Late\";");
            printWriter.println("}");
            printWriter.close();
        }
    }

    private static class InstallWindowsRemoteCallable
    extends AbstractRemoteCallable {
        String usedName;
        String binaryPath;
        private boolean interactive;
        private boolean autoStart;
        private boolean keepCurrentAccount;
        private String dependencies;
        private String accountName;
        private String password;
        private String accountNameOrSidForPrivileges;
        private String description;
        private int priority;
        private boolean restartOnFailure;

        private InstallWindowsRemoteCallable(String string, String string2, boolean bl, boolean bl2, boolean bl3, String string3, String string4, String string5, String string6, String string7, int n, boolean bl4) {
            this.usedName = string;
            this.binaryPath = string2;
            this.interactive = bl;
            this.autoStart = bl2;
            this.keepCurrentAccount = bl3;
            this.dependencies = string3;
            this.accountName = string4;
            this.password = string5;
            this.accountNameOrSidForPrivileges = string6;
            this.description = string7;
            this.priority = n;
            this.restartOnFailure = bl4;
        }

        public Serializable execute() {
            boolean bl = false;
            try {
                try {
                    Win32Services.installService(this.usedName, this.binaryPath);
                }
                catch (Win32Services.ServiceException serviceException) {
                    if (serviceException.getErrorCode() == 1073) {
                        bl = true;
                    }
                    throw serviceException;
                }
                if (this.keepCurrentAccount && bl) {
                    this.accountName = null;
                    this.password = null;
                    this.accountNameOrSidForPrivileges = null;
                }
                WinRegistry.createKey(RegistryRoot.HKEY_LOCAL_MACHINE, InstallServiceAction.REGKEY_PRIORITY);
                WinRegistry.setValue(RegistryRoot.HKEY_LOCAL_MACHINE, InstallServiceAction.REGKEY_PRIORITY, this.usedName, new Integer(this.priority));
                Win32Services.changeServiceConfig(this.usedName, this.binaryPath, this.interactive, this.autoStart ? 2 : 3, this.dependencies, this.accountName, this.password, this.description);
                Win32Services.setRestartServiceConfig(this.usedName, this.restartOnFailure, 1000);
                if (this.accountNameOrSidForPrivileges != null) {
                    Win32UserInfo.setLsaAccountRight(this.accountNameOrSidForPrivileges, "SeServiceLogonRight", true);
                }
            }
            catch (Win32Services.ServiceException serviceException) {
                return serviceException;
            }
            return null;
        }
    }

    private static class UninstallMacosRemoteCallable
    extends AbstractRemoteCallable {
        private File serviceExecutable;
        String serviceName;
        private String identifier;
        private String startupType;

        private UninstallMacosRemoteCallable(File file, String string, String string2, String string3) {
            this.serviceExecutable = file;
            this.serviceName = string;
            this.identifier = string2;
            this.startupType = string3;
        }

        public Serializable execute() {
            File file;
            if (this.serviceName != null && this.serviceName.trim().length() > 0 && "auto".equals(this.startupType)) {
                file = new File(InstallServiceAction.STARTUP_ITEMS_FILE_NAME, this.serviceName);
                FileUtil.deleteDirectory(file);
            }
            if (this.identifier != null && (file = new File(InstallServiceAction.LAUNCH_DAEMONS_FILE_NAME, this.identifier + ".plist")).exists()) {
                LaunchDescriptor launchDescriptor = new LaunchDescriptor(new File("/bin/launchctl")).wait(true).executionContext(ExecutionContext.MAXIMUM).runAsUser("root");
                Integer n = LaunchHelper.launchApplication(launchDescriptor.arguments(new String[]{"unload", file.getAbsolutePath()}));
                Logger.getInstance().info(this, "Unload: " + (n != null && n == 0));
                if (!file.delete()) {
                    file.deleteOnExit();
                }
                return null;
            }
            try {
                Execution.executeAndWait(new String[]{"/bin/sh", this.serviceExecutable.getAbsolutePath(), "stop"}, null);
            }
            catch (IOException iOException) {
                iOException.printStackTrace();
            }
            return null;
        }
    }

    private static class UninstallWindowsRemoteCallable
    extends AbstractRemoteCallable {
        String serviceName;
        private String binaryPath;

        private UninstallWindowsRemoteCallable(String string, String string2) {
            this.serviceName = string;
            this.binaryPath = string2;
        }

        public Serializable execute() {
            block3: {
                try {
                    String string = Win32Services.getServiceBinary(this.serviceName);
                    if (this.binaryPath == null || this.binaryPath.equals(string)) {
                        Win32Services.uninstallService(this.serviceName);
                    }
                }
                catch (Win32Services.ServiceException serviceException) {
                    if (serviceException.getErrorCode() == 1060) break block3;
                    return serviceException;
                }
            }
            return null;
        }
    }
}

