/*
 * Decompiled with CFR 0.152.
 */
package com.install4j.runtime.beans.screens.componentselection;

import com.install4j.runtime.beans.screens.componentselection.ComponentFolderNode;
import com.install4j.runtime.beans.screens.componentselection.ComponentTreeModel;
import com.install4j.runtime.installer.config.ComponentNodeConfig;
import java.util.Enumeration;
import java.util.Iterator;
import javax.swing.tree.DefaultMutableTreeNode;
import javax.swing.tree.TreeNode;
import javax.swing.tree.TreePath;

public class ComponentNode
extends DefaultMutableTreeNode
implements ComponentNodeConfig.ComponentChangeListener {
    private ComponentNodeConfig config;
    private ComponentTreeModel model;
    private boolean inUserSelectionChange;

    public ComponentNode(ComponentNodeConfig componentNodeConfig, ComponentTreeModel componentTreeModel) {
        this.model = componentTreeModel;
        this.config = componentNodeConfig;
        if (componentNodeConfig != null) {
            componentNodeConfig.addComponentChangeListener(this);
        }
    }

    public void selectionChanged(ComponentNodeConfig componentNodeConfig) {
        this.model.getTree().selectionChanged(this, !this.inUserSelectionChange);
        this.redrawNodeAndParents();
    }

    public void changeableChanged(ComponentNodeConfig componentNodeConfig) {
        this.redrawNodeAndParents();
    }

    public void setModel(ComponentTreeModel componentTreeModel) {
        this.model = componentTreeModel;
    }

    public void hiddenChanged(ComponentNodeConfig componentNodeConfig) {
        ComponentFolderNode componentFolderNode = (ComponentFolderNode)this.getParent();
        if (componentFolderNode != null) {
            if (componentNodeConfig.isHidden()) {
                componentFolderNode.hide(this);
            } else {
                componentFolderNode.show(this);
            }
            componentFolderNode.checkState();
        }
    }

    private void redrawNodeAndParents() {
        this.changed();
        ComponentFolderNode componentFolderNode = (ComponentFolderNode)this.getParent();
        if (componentFolderNode != null) {
            componentFolderNode.checkState();
        }
    }

    public ComponentNodeConfig getComponentNodeConfig() {
        return this.config;
    }

    public boolean isSelected() {
        return this.config.isSelected();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void setSelected(boolean bl, boolean bl2) {
        if (!this.isChangeable()) {
            return;
        }
        this.inUserSelectionChange = bl2;
        try {
            this.config.setSelected(bl);
            this.changed();
            if (this.children != null) {
                this.setChildrenSelected(bl);
                if (!bl && this.getSelectedChildrenCount() > 0) {
                    int n;
                    int n2 = 0;
                    while (n2 != (n = this.getSelectedChildrenCount())) {
                        this.setChildrenSelected(false);
                        n2 = n;
                    }
                }
            }
            Enumeration<TreeNode> enumeration = ((DefaultMutableTreeNode)this.model.getRoot()).depthFirstEnumeration();
            while (enumeration.hasMoreElements()) {
                DefaultMutableTreeNode defaultMutableTreeNode = (DefaultMutableTreeNode)enumeration.nextElement();
                if (!defaultMutableTreeNode.isLeaf()) continue;
                ((ComponentFolderNode)defaultMutableTreeNode.getParent()).checkState();
            }
        }
        finally {
            this.inUserSelectionChange = false;
        }
    }

    private int getSelectedChildrenCount() {
        int n = 0;
        Iterator iterator = this.children.iterator();
        while (iterator.hasNext()) {
            ComponentNode componentNode = (ComponentNode)iterator.next();
            if (!componentNode.isSelected()) continue;
            ++n;
        }
        return n;
    }

    private void setChildrenSelected(boolean bl) {
        Iterator iterator = this.children.iterator();
        while (iterator.hasNext()) {
            ComponentNode componentNode = (ComponentNode)iterator.next();
            componentNode.setSelected(bl, false);
        }
    }

    protected void changed() {
        if (this.model != null) {
            this.model.nodeChanged(this);
        }
    }

    protected boolean isChangeable() {
        return true;
    }

    public void setDisplayDescription(boolean bl) {
        if (this.config == null) {
            return;
        }
        this.model.getTree().stopEditing();
        this.config.setDisplayDescription(bl);
        this.model.getTree().startEditingAtPath(new TreePath(this.getPath()));
        this.model.getTree().stopEditing();
        this.changed();
    }

    public void toggleDisplayDescription() {
        this.setDisplayDescription(!this.config.isDisplayDescription());
    }

    protected ComponentTreeModel getModel() {
        return this.model;
    }
}

