/*
 * Decompiled with CFR 0.152.
 */
package com.install4j.runtime.installer.frontend.headless;

import com.install4j.api.Util;
import com.install4j.api.beans.ScriptProperty;
import com.install4j.api.context.DefaultUnattendedProgressInterface;
import com.install4j.api.context.ProgressInterface;
import com.install4j.api.context.UnattendedProgressInterface;
import com.install4j.api.context.UserCanceledException;
import com.install4j.api.screens.FormPanelContainer;
import com.install4j.api.screens.Screen;
import com.install4j.runtime.installer.DummyWizardContext;
import com.install4j.runtime.installer.config.InstallerConfig;
import com.install4j.runtime.installer.config.LanguageConfig;
import com.install4j.runtime.installer.config.ScreenBeanConfig;
import com.install4j.runtime.installer.controller.FinishCommand;
import com.install4j.runtime.installer.controller.ReturnToken;
import com.install4j.runtime.installer.frontend.FormPanel;
import com.install4j.runtime.installer.frontend.GUIHelper;
import com.install4j.runtime.installer.frontend.Messages;
import com.install4j.runtime.installer.frontend.SplashProgressInterface;
import com.install4j.runtime.installer.frontend.headless.AbstractHeadlessScreenExecutor;
import com.install4j.runtime.installer.helper.ConsoleImpl;
import com.install4j.runtime.installer.helper.RunningProcessChecker;
import java.awt.Window;
import java.io.File;
import java.util.List;
import java.util.Locale;

public abstract class UnattendedScreenExecutor
extends AbstractHeadlessScreenExecutor {
    private UnattendedProgressInterface progressInterface;
    private boolean quietOverwrite;
    private int wait;
    private String splash;
    private boolean dialog;
    private Window parentWindow;
    private boolean suppressStdout;
    private boolean detailStdout;

    public UnattendedScreenExecutor(boolean bl, int n, String string, boolean bl2, Window window) {
        this.quietOverwrite = bl;
        this.wait = n;
        this.splash = string;
        this.dialog = bl2;
        this.parentWindow = window;
        this.suppressStdout = Boolean.getBoolean("install4j.suppressStdout");
        this.detailStdout = Boolean.getBoolean("install4j.detailStdout");
        this.init(string == null && this.getUnattendedProgressInterfaceProvider() == null);
    }

    private ScriptProperty getUnattendedProgressInterfaceProvider() {
        ScriptProperty scriptProperty = InstallerConfig.getCurrentApplication().getUnattendedProgressInterfaceProvider();
        if (scriptProperty != null && scriptProperty.getValue() != null && scriptProperty.getValue().length() > 0) {
            return scriptProperty;
        }
        return null;
    }

    protected boolean handleScreen(ScreenBeanConfig screenBeanConfig) {
        if (this.wait > 0) {
            try {
                boolean bl = false;
                for (int i = 0; i < this.wait; ++i) {
                    if (RunningProcessChecker.checkDefaultRunningLauncher(null)) {
                        bl = true;
                        break;
                    }
                    Thread.sleep(1000L);
                }
                if (!bl) {
                    System.err.println(Messages.getMessages().getString("UnattendedRunningFailure"));
                    this.getContext().immediateExit(-1);
                }
            }
            catch (InterruptedException interruptedException) {
                interruptedException.printStackTrace();
            }
            catch (UserCanceledException userCanceledException) {
                // empty catch block
            }
            this.wait = 0;
        }
        Object[] objectArray = null;
        Screen screen = screenBeanConfig.getOrInstantiateScreen(false);
        if (screen instanceof FormPanelContainer) {
            FormPanel formPanel = new FormPanel(screenBeanConfig.getFormComponentConfigs(), this.getContext(), false, screen);
            ((FormPanelContainer)((Object)screen)).setFormPanel(formPanel, formPanel.getFormEnvironment());
            if (!formPanel.handleUnattended()) {
                return false;
            }
            objectArray = new Object[]{formPanel.getFormEnvironment()};
        }
        if (screen.isHidden() || screen.isHiddenForNext()) {
            return true;
        }
        if (!screen.handleUnattended()) {
            return false;
        }
        this.getContext().runBooleanScript(screenBeanConfig.getPreActivationClassName(), screen, objectArray);
        boolean bl = this.getContext().runBooleanScript(screenBeanConfig.getValidationClassName(), screen, objectArray);
        if (screenBeanConfig.isFinishScreen()) {
            this.getCommandSink().returnToController(new FinishCommand(null));
        }
        return bl;
    }

    public boolean isUnattended() {
        return true;
    }

    public boolean isConsole() {
        return false;
    }

    public ProgressInterface getProgressInterface() {
        if (this.progressInterface == null) {
            final ScriptProperty scriptProperty = this.getUnattendedProgressInterfaceProvider();
            if (this.splash == null && scriptProperty == null) {
                this.progressInterface = new NullProgressInterface();
            } else {
                Runnable runnable = new Runnable(){

                    public void run() {
                        GUIHelper.setLaF();
                        try {
                            if (scriptProperty != null) {
                                UnattendedScreenExecutor.this.progressInterface = (UnattendedProgressInterface)UnattendedScreenExecutor.this.getContext().runScript(scriptProperty, InstallerConfig.getCurrentApplication(), null);
                            } else {
                                UnattendedScreenExecutor.this.progressInterface = new SplashProgressInterface(UnattendedScreenExecutor.this.splash, false, UnattendedScreenExecutor.this.quietOverwrite, UnattendedScreenExecutor.this, UnattendedScreenExecutor.this.dialog, UnattendedScreenExecutor.this.parentWindow);
                            }
                            UnattendedScreenExecutor.this.progressInterface.setVisible(true);
                        }
                        catch (Exception exception) {
                            Util.fatalError(exception);
                        }
                    }
                };
                try {
                    GUIHelper.invokeOnEDT(runnable);
                }
                catch (Exception exception) {
                    exception.printStackTrace();
                    this.progressInterface = new NullProgressInterface();
                }
            }
        }
        return this.progressInterface;
    }

    public void closeWindows() {
        if (this.progressInterface != null) {
            this.progressInterface.setVisible(false);
        }
    }

    public void selectLanguage(ReturnToken returnToken) {
        String string = null;
        List list = InstallerConfig.getCurrentInstance().getLanguages();
        String string2 = Locale.getDefault().getLanguage();
        LanguageConfig languageConfig = InstallerConfig.getCurrentInstance().getLanguageById(string2);
        if (languageConfig != null) {
            string = languageConfig.getId();
        } else if (list.size() > 0) {
            string = ((LanguageConfig)list.get(0)).getId();
        }
        returnToken.returnToController(string);
    }

    protected DummyWizardContext createWizardContext() {
        return new UnattendedWizardContext();
    }

    private class NullProgressInterface
    extends DefaultUnattendedProgressInterface {
        private NullProgressInterface() {
        }

        public void setStatusMessage(String string) {
            if (!UnattendedScreenExecutor.this.suppressStdout) {
                ConsoleImpl.getInstance().setStatusMessage(string);
            }
        }

        public void setDetailMessage(String string) {
            if (UnattendedScreenExecutor.this.detailStdout) {
                ConsoleImpl.getInstance().setDetailMessage(string);
            }
        }

        public void showFailure(String string) {
            ConsoleImpl.getInstance().showFailure(string);
        }

        public int askOverwrite(File file) {
            if (UnattendedScreenExecutor.this.quietOverwrite) {
                return 2;
            }
            return 1;
        }
    }

    private class UnattendedWizardContext
    extends DummyWizardContext {
        private UnattendedWizardContext() {
        }

        public void setCancelButtonEnabled(boolean bl) {
            UnattendedScreenExecutor.this.progressInterface.setCancelButtonEnabled(bl);
        }

        public void setCancelButtonVisible(boolean bl) {
            UnattendedScreenExecutor.this.progressInterface.setCancelButtonVisible(bl);
        }
    }
}

