/*
 * Decompiled with CFR 0.152.
 */
package com.install4j.runtime.installer.helper;

import com.exe4j.runtime.util.ResourceHelper;
import com.install4j.api.context.Context;
import com.install4j.runtime.installer.config.InstallerConfig;
import com.install4j.runtime.installer.helper.InstallerUtil;
import com.install4j.runtime.installer.helper.comm.ExecutionContext;
import com.install4j.runtime.installer.helper.comm.HelperCommunication;
import com.install4j.runtime.installer.helper.comm.actions.RunAction;
import java.io.File;
import java.io.IOException;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.net.MalformedURLException;
import java.net.URL;
import java.net.URLClassLoader;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Set;

public class ClasspathModificator {
    private static ClassLoader classLoader;
    private static Method addURLMethod;
    private static boolean customJarsAdded;
    private static Set addedFiles;

    public static void addClassPath(final File file) {
        HelperCommunication.getInstance().executeAction(ExecutionContext.ALL, new RunAction(){

            protected void run(Context context) {
                ClasspathModificator.addClassPathInt(file);
            }
        });
    }

    private static void addClassPathInt(File file) {
        try {
            file = file.getCanonicalFile();
        }
        catch (IOException iOException) {
            // empty catch block
        }
        if (file == null || addedFiles.contains(file)) {
            return;
        }
        if (addURLMethod == null) {
            classLoader = Thread.currentThread().getContextClassLoader();
            addURLMethod = ClasspathModificator.getAddURLMethod();
        }
        try {
            addURLMethod.invoke((Object)classLoader, file.toURL());
            System.setProperty("java.class.path", System.getProperty("java.class.path") + File.pathSeparator + file.getAbsolutePath());
            addedFiles.add(file);
        }
        catch (IllegalAccessException illegalAccessException) {
            throw new RuntimeException(illegalAccessException);
        }
        catch (InvocationTargetException invocationTargetException) {
            throw new RuntimeException(invocationTargetException);
        }
        catch (MalformedURLException malformedURLException) {
            throw new RuntimeException(malformedURLException);
        }
    }

    private static Method getAddURLMethod() {
        try {
            Method method = URLClassLoader.class.getDeclaredMethod("addURL", URL.class);
            method.setAccessible(true);
            return method;
        }
        catch (NoSuchMethodException noSuchMethodException) {
            throw new RuntimeException(noSuchMethodException);
        }
    }

    public static void addCustomJarsToClasspath(Context context) {
        if (customJarsAdded) {
            return;
        }
        if (InstallerUtil.isInProcess()) {
            ClasspathModificator.addClassPath(new File(ResourceHelper.getRuntimeDir(), "user.jar"));
        }
        List list = InstallerConfig.getCurrentInstance().getCustomJars();
        Iterator iterator = list.iterator();
        while (iterator.hasNext()) {
            String string = (String)iterator.next();
            ClasspathModificator.addClassPath(context.getDestinationFile(string));
        }
        customJarsAdded = true;
    }

    static {
        customJarsAdded = false;
        addedFiles = new HashSet();
        String string = System.getProperty("java.class.path");
        if (string != null) {
            String[] stringArray = string.split(File.pathSeparator);
            for (int i = 0; i < stringArray.length; ++i) {
                String string2 = stringArray[i];
                if (string2.length() <= 0) continue;
                try {
                    addedFiles.add(new File(string2).getCanonicalFile());
                    continue;
                }
                catch (IOException iOException) {
                    // empty catch block
                }
            }
        }
    }
}

