/*
 * Decompiled with CFR 0.152.
 */
package com.install4j.runtime.installer.helper;

import com.exe4j.runtime.util.FileUtil;
import com.install4j.api.Util;
import com.install4j.api.actions.Action;
import com.install4j.api.beans.Bean;
import com.install4j.api.beans.PropertyLoggingInterceptor;
import com.install4j.api.context.Context;
import com.install4j.api.context.UserCanceledException;
import com.install4j.api.events.EventType;
import com.install4j.api.events.InstallerEvent;
import com.install4j.api.events.InstallerEventListener;
import com.install4j.api.screens.Screen;
import com.install4j.runtime.installer.InstallerVariables;
import com.install4j.runtime.installer.config.AbstractBeanConfig;
import com.install4j.runtime.installer.config.InstallerConfig;
import com.install4j.runtime.installer.helper.Logger;
import com.install4j.runtime.installer.helper.comm.HelperCommunication;
import com.install4j.runtime.installer.helper.comm.actions.FetchBooleanAction;
import com.install4j.runtime.installer.helper.content.ContentInstaller;
import com.install4j.runtime.installer.helper.versionspecific.VersionSpecificHelper;
import com.install4j.runtime.util.StringUtil;
import java.io.File;
import java.io.FileDescriptor;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.io.PrintWriter;
import java.lang.ref.WeakReference;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.util.Date;

public class LoggerImpl
extends Logger
implements InstallerEventListener {
    private PrintWriter out;
    private File logFile;
    private boolean moved;
    private WeakReference lastSource;
    private String lastPrefix;
    private Action currentAction;
    private Screen currentScreen;
    private File finalLogFile;

    LoggerImpl() {
        InstallerConfig installerConfig = InstallerConfig.getCurrentInstance();
        try {
            String string;
            String string2;
            String string3 = System.getProperty("install4j.alternativeLogfile");
            if ("null".equals(string3)) {
                string3 = null;
            }
            if ((string2 = string3) != null) {
                this.logFile = new File(string2);
                this.logFile.getParentFile().mkdirs();
            } else {
                string = "i4j_log";
                String string4 = null;
                if (installerConfig != null) {
                    string4 = (String)InstallerConfig.getCurrentInstance().getCompilerVariables().get("sys.shortName");
                }
                if (string4 != null) {
                    string = string + "_" + string4 + "_";
                }
                this.logFile = File.createTempFile(string, ".log");
            }
            Runtime.getRuntime().addShutdownHook(new Thread("delete_log"){

                public void run() {
                    if (!Boolean.getBoolean("install4j.keepLog") && string2 == null && LoggerImpl.this.logFile != null && !LoggerImpl.this.moved) {
                        LoggerImpl.this.out.close();
                        LoggerImpl.this.logFile.delete();
                    }
                }
            });
            string = System.getProperty("install4j.logEncoding");
            this.out = string != null ? new PrintWriter(new OutputStreamWriter((OutputStream)new FileOutputStream(this.logFile), string)) : new PrintWriter(new OutputStreamWriter(new FileOutputStream(this.logFile)));
        }
        catch (IOException iOException) {
            iOException.printStackTrace();
            this.out = new PrintWriter(new OutputStreamWriter(new FileOutputStream(FileDescriptor.out)));
        }
        InstallerVariables.registerVariableProvider("sys.logFile", new InstallerVariables.VariableProvider(){

            public Object getVariable() {
                try {
                    return LoggerImpl.this.logFile.getCanonicalPath();
                }
                catch (IOException iOException) {
                    return LoggerImpl.this.logFile.getAbsolutePath();
                }
            }

            public void setVariable(Object object) {
            }
        });
        this.info(null, "logger started at " + new Date());
        this.info(null, "executable name: " + System.getProperty("exe4j.moduleName"));
        if (installerConfig != null) {
            this.info(null, "install4j version: " + installerConfig.getInstall4jVersion() + " (build " + installerConfig.getInstall4jBuild() + ")");
        }
        this.info(null, "Properties: ");
        System.getProperties().list(this.out);
    }

    public File getLogFile() {
        return this.logFile;
    }

    public void closeLogFile() {
        this.out.close();
    }

    public synchronized void moveLogFile() {
        if (this.logFile != null && this.finalLogFile != null && !Boolean.getBoolean("install4j.noPermanentLogFile")) {
            this.moved = true;
            this.closeLogFile();
            if (LoggerImpl.moveInt(this.logFile, this.finalLogFile)) {
                this.logFile = this.finalLogFile;
            }
        }
    }

    private static boolean moveInt(final File file, final File file2) {
        final String string = System.getProperty("install4j.runtimeAccessMode");
        return HelperCommunication.getInstance().fetchBoolean(ContentInstaller.getExecutionContext(), new FetchBooleanAction(){

            protected boolean fetchValue(Context context) throws UserCanceledException {
                try {
                    FileUtil.copyFile(file, file2);
                    if (!Boolean.getBoolean("install4j.keepLog")) {
                        file.delete();
                    }
                    if (string != null && !Util.isWindows()) {
                        VersionSpecificHelper.setPosixFilePermissions(file2, string);
                    }
                    return true;
                }
                catch (IOException iOException) {
                    System.err.println("could not copy log file: " + iOException.getMessage());
                    return false;
                }
            }
        });
    }

    public void installerEvent(InstallerEvent installerEvent) {
        EventType eventType = installerEvent.getType();
        if (LOGGED_EVENT_TYPES.contains(eventType) || !installerEvent.wasSuccessful() && LOGGED_EVENT_TYPES_FAILURE_ONLY.contains(eventType)) {
            this.log(installerEvent.getSource(), installerEvent.getVerbose(), installerEvent.wasSuccessful());
        }
        if (eventType == EventType.BEFORE_EXECUTE_ACTION) {
            this.logActionProperties(installerEvent.getSource());
        }
    }

    public void switchToSecondaryProcess() {
        System.getProperties().remove("install4j.alternativeLogfile");
    }

    public synchronized void log(Throwable throwable) {
        this.error(null, throwable.toString());
        this.out.print(Util.getAnnotatedStackTrace(throwable));
        this.out.flush();
        if (Boolean.getBoolean("install4j.logToStderr")) {
            throwable.printStackTrace();
        }
    }

    public synchronized void log(Object object, String string, boolean bl) {
        boolean bl2;
        if (object instanceof Context) {
            object = null;
        }
        if (object == null && this.currentAction != null) {
            object = this.currentAction;
        }
        if (object == null && this.currentScreen != null) {
            object = this.currentScreen;
        }
        StringBuffer stringBuffer = new StringBuffer();
        String string2 = this.getPrefix(bl);
        boolean bl3 = bl2 = this.lastSource != null && object != null && this.lastSource.get() == object && string2.equals(this.lastPrefix);
        if (bl2) {
            stringBuffer.append(StringUtil.repeat(" ", string2.length()));
        } else {
            stringBuffer.append(string2);
            if (object != null) {
                String string3;
                if (object instanceof Class) {
                    stringBuffer.append(((Class)object).getName());
                } else {
                    stringBuffer.append(object.getClass().getName());
                }
                if (object instanceof Bean && (string3 = AbstractBeanConfig.getId((Bean)object)) != null) {
                    stringBuffer.append(" [ID ");
                    stringBuffer.append(string3);
                    stringBuffer.append("]");
                }
                stringBuffer.append(": ");
            }
            this.lastSource = new WeakReference<Object>(object);
            this.lastPrefix = string2;
        }
        stringBuffer.append(string);
        this.out.println(stringBuffer.toString());
        this.out.flush();
        if (Boolean.getBoolean("install4j.logToStderr")) {
            System.err.println(stringBuffer.toString());
        }
    }

    private String getPrefix(boolean bl) {
        if (bl) {
            return "[INFO] ";
        }
        return "[ERROR] ";
    }

    private void logActionProperties(Object object) {
        Method[] methodArray = object.getClass().getMethods();
        for (int i = 0; i < methodArray.length; ++i) {
            Method method = methodArray[i];
            String string = method.getName();
            if (method.getParameterTypes().length != 0 || string.equals("getClass") || (!string.startsWith("get") || string.length() <= 3) && (!string.startsWith("is") || string.length() <= 2)) continue;
            try {
                this.logProperty(object, string, method.invoke(object, null));
                continue;
            }
            catch (IllegalAccessException illegalAccessException) {
                continue;
            }
            catch (InvocationTargetException invocationTargetException) {
                // empty catch block
            }
        }
    }

    private void logProperty(Object object, String string, Object object2) {
        String string2 = string.startsWith("get") ? string.substring(3, 4).toLowerCase() + string.substring(4) : string.substring(2, 3).toLowerCase() + string.substring(3);
        if (object instanceof PropertyLoggingInterceptor) {
            object2 = ((PropertyLoggingInterceptor)object).getLogValueForProperty(string2, object2);
        }
        this.info(object, "Property " + string2 + ": " + VersionSpecificHelper.toStringWithArrays(object2));
    }

    public void resetOrigin() {
        this.lastSource = null;
        this.lastPrefix = null;
    }

    public void setCurrentScreen(Screen screen) {
        this.currentScreen = screen;
    }

    public void setCurrentAction(Action action) {
        this.currentAction = action;
    }

    public void setFinalLogFile(File file) {
        this.finalLogFile = file;
    }
}

