/*
 * Decompiled with CFR 0.152.
 */
package com.install4j.runtime.installer.helper.comm;

import com.install4j.api.Util;
import com.install4j.api.context.Context;
import com.install4j.api.context.NotSupportedInElevationException;
import com.install4j.api.context.UserCanceledException;
import com.install4j.runtime.installer.ContextImpl;
import com.install4j.runtime.installer.InstallerVariables;
import com.install4j.runtime.installer.config.InstallerConfig;
import com.install4j.runtime.installer.helper.InstallerUtil;
import com.install4j.runtime.installer.helper.Logger;
import com.install4j.runtime.installer.helper.comm.CommunicationBackend;
import com.install4j.runtime.installer.helper.comm.ExecutionContext;
import com.install4j.runtime.installer.helper.comm.actions.CommunicationAction;
import com.install4j.runtime.installer.helper.comm.actions.FetchBooleanAction;
import com.install4j.runtime.installer.helper.comm.actions.FetchIntAction;
import com.install4j.runtime.installer.helper.comm.actions.FetchLongAction;
import com.install4j.runtime.installer.helper.comm.actions.FetchObjectAction;
import com.install4j.runtime.installer.helper.comm.actions.FetchStringAction;
import com.install4j.runtime.installer.helper.comm.actions.RunAction;
import com.install4j.runtime.installer.helper.comm.impl.HelperContextImpl;
import com.install4j.runtime.installer.helper.comm.impl.InstallerHelperContextImpl;
import com.install4j.runtime.installer.helper.comm.impl.UninstallerHelperContextImpl;
import com.install4j.runtime.installer.helper.comm.responses.BooleanResponse;
import com.install4j.runtime.installer.helper.comm.responses.IntResponse;
import com.install4j.runtime.installer.helper.comm.responses.LongResponse;
import com.install4j.runtime.installer.helper.comm.responses.ObjectResponse;
import com.install4j.runtime.installer.helper.comm.responses.Response;
import com.install4j.runtime.installer.helper.comm.responses.StringResponse;
import com.install4j.runtime.installer.helper.comm.responses.ThrowableResponse;
import com.install4j.runtime.installer.helper.fileinst.FileInstaller;
import com.install4j.runtime.installer.platform.unix.PipeCommunicationBackend;
import com.install4j.runtime.installer.platform.unix.TcpCommunicationBackend;
import com.install4j.runtime.installer.platform.win32.Win32CommunicationBackend;
import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.DataOutputStream;
import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InvalidClassException;
import java.io.NotSerializableException;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;
import java.io.PrintStream;
import java.io.Serializable;
import java.text.DateFormat;
import java.util.Date;
import java.util.HashMap;
import java.util.Map;
import java.util.Stack;

public class HelperCommunication {
    private static final int TIMEOUT = 120000;
    private static HelperCommunication instance = new HelperCommunication();
    private boolean terminated;
    private static PrintStream debugLogWriter;
    private boolean connected = false;
    private ByteArrayOutputStream bout = new ByteArrayOutputStream();
    private DataOutputStream dout = new DataOutputStream(this.bout);
    private Thread executorThread;
    private CommunicationBackend backend;
    private HelperContextImpl helperContext;
    private final Stack actions = new Stack();
    private final Map responses = new HashMap();
    private final Object sendMonitor = new Object();
    private long nextPacketId = 1L;
    private long lastPing = -1L;

    public static HelperCommunication getInstance() {
        return instance;
    }

    public String getParentIdentifier() {
        return System.getProperty("install4j.commIdentifier");
    }

    public boolean isElevatedHelper() {
        return this.getParentIdentifier() != null;
    }

    public boolean hasElevatedHelper() {
        try {
            return !this.isElevatedHelper() && this.isConnected();
        }
        catch (Exception exception) {
            exception.printStackTrace();
            return false;
        }
    }

    public boolean connect() {
        if (this.getBackend().connect(this.getParentIdentifier())) {
            this.connected = true;
            if (this.isElevatedHelper()) {
                this.helperContext = InstallerConfig.getCurrentApplicationId().equals("uninstaller") ? new UninstallerHelperContextImpl() : new InstallerHelperContextImpl();
                ContextImpl.setSingleContextInt(this.helperContext);
                FileInstaller.getInstance().setDefaultProgressInterface(this.helperContext.getProgressInterface());
            }
            new ReaderThread().start();
            this.executorThread = new Thread("helper_ipc_executor"){

                public void run() {
                    while (true) {
                        HelperCommunication.this.executeActionWrapper(HelperCommunication.this.getNextAction(true), true);
                    }
                }
            };
            this.executorThread.start();
            new Thread("helper_ipc_ping"){
                {
                    this.setDaemon(true);
                }

                public void run() {
                    while (true) {
                        try {
                            Thread.sleep(5000L);
                        }
                        catch (InterruptedException interruptedException) {
                            // empty catch block
                        }
                        HelperCommunication.ping();
                        if (!HelperCommunication.this.isElevatedHelper() || HelperCommunication.this.lastPing <= -1L || System.currentTimeMillis() - HelperCommunication.this.lastPing <= 120000L) continue;
                        System.exit(1);
                    }
                }
            }.start();
            if (this.hasElevatedHelper()) {
                Runtime.getRuntime().addShutdownHook(new Thread("helper_ipc_shutdown"){

                    public void run() {
                        HelperCommunication.this.terminate();
                    }
                });
            } else {
                InstallerUtil.initHelperState();
                InstallerVariables.initHelperState();
                Logger.getInstance().log(this, "Using communication backend " + this.backend.getClass().getName(), true);
            }
        }
        return this.connected;
    }

    private static void ping() {
        try {
            HelperCommunication.getInstance().executeAction(ExecutionContext.OTHER, new DirectRunAction(){

                protected void run(Context context) {
                    HelperCommunication.getInstance().lastPing = System.currentTimeMillis();
                }
            });
        }
        catch (Throwable throwable) {
            // empty catch block
        }
    }

    public String createListener() {
        return this.getBackend().createListener();
    }

    public String fetchStringChecked(ExecutionContext executionContext, FetchStringAction fetchStringAction) throws UserCanceledException, IOException {
        return ((StringResponse)this.executeActionChecked(executionContext, fetchStringAction)).getValue();
    }

    public Object fetchObjectChecked(ExecutionContext executionContext, FetchObjectAction fetchObjectAction) throws UserCanceledException, IOException {
        return ((ObjectResponse)this.executeActionChecked(executionContext, fetchObjectAction)).getValue();
    }

    public long fetchLongChecked(ExecutionContext executionContext, FetchLongAction fetchLongAction) throws UserCanceledException, IOException {
        return ((LongResponse)this.executeActionChecked(executionContext, fetchLongAction)).getValue();
    }

    public boolean fetchBooleanChecked(ExecutionContext executionContext, FetchBooleanAction fetchBooleanAction) throws UserCanceledException, IOException {
        return ((BooleanResponse)this.executeActionChecked(executionContext, fetchBooleanAction)).getValue();
    }

    public int fetchIntChecked(ExecutionContext executionContext, FetchIntAction fetchIntAction) throws UserCanceledException, IOException {
        return ((IntResponse)this.executeActionChecked(executionContext, fetchIntAction)).getValue();
    }

    public Response executeActionChecked(ExecutionContext executionContext, CommunicationAction communicationAction) throws UserCanceledException, IOException {
        try {
            return this.executeActionInt(executionContext, communicationAction);
        }
        catch (Throwable throwable) {
            if (throwable instanceof Error) {
                throw (Error)throwable;
            }
            if (throwable instanceof RuntimeException) {
                throw (RuntimeException)throwable;
            }
            if (throwable instanceof UserCanceledException) {
                throw (UserCanceledException)throwable;
            }
            if (throwable instanceof IOException) {
                throw (IOException)throwable;
            }
            throw new RuntimeException(throwable);
        }
    }

    public String fetchString(ExecutionContext executionContext, FetchStringAction fetchStringAction) {
        return ((StringResponse)this.executeAction(executionContext, fetchStringAction)).getValue();
    }

    public Object fetchObject(ExecutionContext executionContext, FetchObjectAction fetchObjectAction) {
        return ((ObjectResponse)this.executeAction(executionContext, fetchObjectAction)).getValue();
    }

    public long fetchLong(ExecutionContext executionContext, FetchLongAction fetchLongAction) {
        return ((LongResponse)this.executeAction(executionContext, fetchLongAction)).getValue();
    }

    public boolean fetchBoolean(ExecutionContext executionContext, FetchBooleanAction fetchBooleanAction) {
        return ((BooleanResponse)this.executeAction(executionContext, fetchBooleanAction)).getValue();
    }

    public int fetchInt(ExecutionContext executionContext, FetchLongAction fetchLongAction) {
        return (int)((LongResponse)this.executeAction(executionContext, fetchLongAction)).getValue();
    }

    public Response executeAction(ExecutionContext executionContext, CommunicationAction communicationAction) {
        try {
            return this.executeActionInt(executionContext, communicationAction);
        }
        catch (Throwable throwable) {
            if (throwable instanceof Error) {
                throw (Error)throwable;
            }
            if (throwable instanceof RuntimeException) {
                throw (RuntimeException)throwable;
            }
            throw new RuntimeException(throwable);
        }
    }

    private Response executeActionInt(ExecutionContext executionContext, CommunicationAction communicationAction) throws Throwable {
        if (executionContext == null) {
            executionContext = ExecutionContext.SAME;
        }
        if (executionContext == ExecutionContext.ELEVATED) {
            if (this.isElevatedHelper()) {
                return this.executeActionDirect(communicationAction);
            }
            return this.executeOther(communicationAction);
        }
        if (executionContext == ExecutionContext.UNELEVATED) {
            if (!this.isElevatedHelper() || !this.isConnected()) {
                return this.executeActionDirect(communicationAction);
            }
            return this.executeOther(communicationAction);
        }
        if (executionContext == ExecutionContext.SAME) {
            return this.executeActionDirect(communicationAction);
        }
        if (executionContext == ExecutionContext.OTHER) {
            return this.executeOther(communicationAction);
        }
        if (executionContext == ExecutionContext.MAXIMUM) {
            if (this.isElevatedHelper() || !this.hasElevatedHelper()) {
                return this.executeActionDirect(communicationAction);
            }
            return this.executeOther(communicationAction);
        }
        if (executionContext == ExecutionContext.ALL) {
            if (this.isConnected()) {
                this.executeOther(communicationAction);
            }
            return this.executeActionDirect(communicationAction);
        }
        throw new RuntimeException("unknown ExecutionContext " + executionContext);
    }

    private Response executeActionDirect(CommunicationAction communicationAction) throws Throwable {
        Response response = communicationAction.execute(this.getContext());
        if (response instanceof ThrowableResponse) {
            throw ((ThrowableResponse)response).getThrowable();
        }
        return response;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private Response executeOther(CommunicationAction communicationAction) throws Throwable {
        if (!this.isConnected()) {
            throw new RuntimeException("other process not connected");
        }
        try {
            Long l;
            Object object = this.sendMonitor;
            synchronized (object) {
                l = new Long(this.nextPacketId++);
            }
            this.sendObject(new ActionWrapper(l, communicationAction));
            if (!(communicationAction instanceof RunNoWaitAction)) {
                object = this.responses;
                synchronized (object) {
                    Response response = (Response)this.responses.get(l);
                    while (response == null) {
                        try {
                            this.responses.wait();
                        }
                        catch (InterruptedException interruptedException) {
                            interruptedException.printStackTrace();
                        }
                        if ((response = (Response)this.responses.get(l)) != null || Thread.currentThread() != this.executorThread) continue;
                        ActionWrapper actionWrapper = this.getNextAction(false);
                        if (actionWrapper != null) {
                            this.executeActionWrapper(actionWrapper, true);
                        }
                        response = (Response)this.responses.get(l);
                    }
                    if (response instanceof ThrowableResponse) {
                        throw ((ThrowableResponse)response).getThrowable();
                    }
                    return response;
                }
            }
            return null;
        }
        catch (IOException iOException) {
            if (!this.isElevatedHelper() && !this.terminated) {
                Logger.getInstance().log(iOException);
            }
            throw new RuntimeException(iOException);
        }
    }

    private CommunicationBackend getBackend() {
        if (this.backend == null) {
            if (Util.isAtLeastWindowsVista()) {
                this.backend = new Win32CommunicationBackend();
            } else if (Util.isMacOS()) {
                this.backend = new PipeCommunicationBackend();
            }
            if (this.backend == null) {
                this.backend = new TcpCommunicationBackend();
            }
        }
        return this.backend;
    }

    public void terminate() {
        if (this.hasElevatedHelper() && this.isConnected()) {
            this.terminated = true;
            HelperCommunication.terminateInt();
        }
    }

    private static void terminateInt() {
        try {
            HelperCommunication.getInstance().executeAction(ExecutionContext.MAXIMUM, new DirectRunAction(){

                protected void run(Context context) {
                    System.exit(0);
                }
            });
        }
        catch (Throwable throwable) {
            // empty catch block
        }
    }

    private void executeActionWrapper(ActionWrapper actionWrapper, boolean bl) {
        Response response;
        try {
            response = actionWrapper.action.execute(this.getContext());
        }
        catch (Throwable throwable) {
            response = new ThrowableResponse(throwable);
        }
        if (bl) {
            try {
                this.sendObject(new ResponseWrapper(actionWrapper.id, response));
            }
            catch (IOException iOException) {
                if (this.isElevatedHelper()) {
                    iOException.printStackTrace();
                }
                Logger.getInstance().log(iOException);
            }
        }
    }

    private Context getContext() {
        return this.helperContext != null ? this.helperContext : ContextImpl.getCurrentContext();
    }

    public static void helperUnsupported() throws NotSupportedInElevationException {
        if (HelperCommunication.getInstance().isElevatedHelper()) {
            throw new NotSupportedInElevationException();
        }
    }

    public static boolean executeAsHelper(String[] stringArray) {
        if (System.getProperty("install4j.helperAppId") != null) {
            HelperCommunication.main(stringArray);
            return true;
        }
        return false;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private ActionWrapper getNextAction(boolean bl) {
        Stack stack = this.actions;
        synchronized (stack) {
            if (bl) {
                while (this.actions.empty()) {
                    try {
                        this.actions.wait();
                    }
                    catch (InterruptedException interruptedException) {
                        interruptedException.printStackTrace();
                    }
                }
                return (ActionWrapper)this.actions.pop();
            }
            if (this.actions.empty()) {
                return null;
            }
            return (ActionWrapper)this.actions.pop();
        }
    }

    public void checkWork() {
    }

    public Object readData() throws IOException {
        byte[] byArray = this.getBackend().readDataBlock();
        if (byArray == null) {
            throw new IOException("read failed");
        }
        ObjectInputStream objectInputStream = new ObjectInputStream(new ByteArrayInputStream(byArray));
        try {
            return objectInputStream.readObject();
        }
        catch (ClassNotFoundException classNotFoundException) {
            throw new IOException(classNotFoundException.toString());
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void sendObject(Object object) throws IOException {
        try {
            Object object2 = this.sendMonitor;
            synchronized (object2) {
                this.bout.reset();
                ObjectOutputStream objectOutputStream = new ObjectOutputStream(this.dout);
                objectOutputStream.writeObject(object);
                objectOutputStream.close();
                if (!this.getBackend().writeDataBlock(this.bout.toByteArray())) {
                    throw new IOException("write failed");
                }
            }
        }
        catch (InvalidClassException invalidClassException) {
            Util.fatalError(invalidClassException);
        }
        catch (NotSerializableException notSerializableException) {
            Util.fatalError(notSerializableException);
        }
    }

    public boolean isConnected() {
        return this.connected;
    }

    public static void main(String[] stringArray) {
        if (InstallerUtil.isAtLeastJava15() && "yes".equals(System.getenv("I4J_LOG_HELPER")) || Boolean.getBoolean("install4j.helperLog")) {
            try {
                File file = Util.isMacOS() ? new File("/var/tmp/i4j_helper.log") : File.createTempFile("i4j_helper", ".log");
                debugLogWriter = new PrintStream(new FileOutputStream(file));
                System.setErr(debugLogWriter);
                System.setOut(debugLogWriter);
            }
            catch (IOException iOException) {
                // empty catch block
            }
        }
        HelperCommunication.log("Started helper");
        InstallerUtil.setUnattended(true);
        InstallerConfig.setCurrentApplicationId(System.getProperty("install4j.helperAppId"));
        HelperCommunication.getInstance().connect();
    }

    public static synchronized void log(String string) {
        if (debugLogWriter != null) {
            debugLogWriter.println(DateFormat.getTimeInstance().format(new Date()) + ": " + string);
            debugLogWriter.flush();
        }
    }

    private static class ActionWrapper
    implements Serializable {
        long id;
        CommunicationAction action;

        private ActionWrapper(long l, CommunicationAction communicationAction) {
            this.id = l;
            this.action = communicationAction;
        }
    }

    public static abstract class DirectRunAction
    extends RunNoWaitAction {
    }

    private class ReaderThread
    extends Thread {
        private ReaderThread() {
            super("helper_ipc_reader");
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         * Enabled force condition propagation
         * Lifted jumps to return sites
         */
        public void handleData(Object object) {
            if (object instanceof ActionWrapper) {
                ActionWrapper actionWrapper = (ActionWrapper)object;
                if (actionWrapper.action instanceof DirectRunAction) {
                    HelperCommunication.this.executeActionWrapper(actionWrapper, false);
                    return;
                }
                Object object2 = HelperCommunication.this.actions;
                synchronized (object2) {
                    HelperCommunication.this.actions.push(object);
                    HelperCommunication.this.actions.notifyAll();
                }
                object2 = HelperCommunication.this.responses;
                synchronized (object2) {
                    HelperCommunication.this.responses.notifyAll();
                    return;
                }
            }
            if (!(object instanceof ResponseWrapper)) return;
            Map map = HelperCommunication.this.responses;
            synchronized (map) {
                ResponseWrapper responseWrapper = (ResponseWrapper)object;
                HelperCommunication.this.responses.put(new Long(responseWrapper.id), responseWrapper.response);
                HelperCommunication.this.responses.notifyAll();
                return;
            }
        }

        public void run() {
            block3: {
                try {
                    while (HelperCommunication.this.isConnected()) {
                        this.handleData(HelperCommunication.this.readData());
                    }
                }
                catch (Throwable throwable) {
                    if (HelperCommunication.this.terminated || HelperCommunication.this.isElevatedHelper()) break block3;
                    Logger.getInstance().log(throwable);
                }
            }
        }
    }

    private static class ResponseWrapper
    implements Serializable {
        long id;
        Response response;

        private ResponseWrapper(long l, Response response) {
            this.id = l;
            this.response = response;
        }
    }

    public static abstract class RunNoWaitAction
    extends RunAction {
    }
}

