/*
 * Decompiled with CFR 0.152.
 */
package com.install4j.runtime.installer.helper.fileinst;

import com.exe4j.runtime.util.FileUtil;
import com.exe4j.runtime.util.ReadIOException;
import com.install4j.api.Util;
import com.install4j.api.context.Context;
import com.install4j.api.context.FileOptions;
import com.install4j.api.context.ProgressInterface;
import com.install4j.api.context.UninstallMode;
import com.install4j.api.context.UserCanceledException;
import com.install4j.api.events.EventType;
import com.install4j.api.events.InstallerFileEvent;
import com.install4j.api.windows.WinFileSystem;
import com.install4j.runtime.installer.ContextImpl;
import com.install4j.runtime.installer.frontend.Messages;
import com.install4j.runtime.installer.frontend.ProgressAdapter;
import com.install4j.runtime.installer.helper.InstallerUtil;
import com.install4j.runtime.installer.helper.Logger;
import com.install4j.runtime.installer.helper.comm.ExecutionContext;
import com.install4j.runtime.installer.helper.comm.HelperCommunication;
import com.install4j.runtime.installer.helper.comm.actions.FetchObjectAction;
import com.install4j.runtime.installer.helper.comm.actions.RunAction;
import com.install4j.runtime.installer.helper.fileinst.BackupPair;
import com.install4j.runtime.installer.helper.fileinst.FileInstallerState;
import com.install4j.runtime.installer.helper.fileinst.FileRemover;
import com.install4j.runtime.installer.helper.fileinst.InstallFile;
import com.install4j.runtime.installer.helper.fileinst.InstallHelper;
import com.install4j.runtime.installer.helper.versionspecific.VersionSpecificHelper;
import java.io.BufferedInputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.Serializable;
import java.text.MessageFormat;
import java.util.ArrayList;
import java.util.List;

public class FileInstaller
implements Serializable {
    static final String LOG_FILENAME = "files.log";
    private static FileInstaller fileInstaller = new FileInstaller();
    private transient ProgressInterface defaultProgressInterface = new ProgressAdapter(null, false);
    private transient String lastOptionsVerbose;
    private transient FileInstallerState installerState = FileInstallerState.getInstance();
    private transient FileRemover fileRemover = new FileRemover();

    public static FileInstaller getInstance() {
        FileInstaller.fileInstaller.lastOptionsVerbose = null;
        return fileInstaller;
    }

    public static void clearFileInstaller() {
        fileInstaller = new FileInstaller();
    }

    FileRemover getFileRemover() {
        return this.fileRemover;
    }

    private BackupPair backupFile(InstallFile installFile) throws IOException {
        Serializable serializable;
        long l = installFile.lastModified();
        File file = File.createTempFile("i4b", null);
        file.delete();
        if (!installFile.renameTo(file)) {
            try {
                serializable = File.createTempFile("i4b", null, installFile.getParentFile());
                serializable.delete();
            }
            catch (IOException iOException) {
                serializable = file;
            }
            if (installFile.renameTo((File)serializable)) {
                file = serializable;
            } else {
                FileUtil.copyFile(installFile, file);
            }
        }
        serializable = new BackupPair(installFile, file, l, HelperCommunication.getInstance().isElevatedHelper());
        this.installerState.addReplacedFile((BackupPair)serializable);
        return serializable;
    }

    private boolean checkFile(File file, InstallFile installFile, int n, UninstallMode uninstallMode, boolean bl, ProgressInterface progressInterface) throws IOException, UserCanceledException {
        this.createDirectory(installFile.getParentFile(), InstallHelper.getParentUninstallMode(uninstallMode));
        if (installFile.exists()) {
            boolean bl2;
            if (n == 0 || (n == 4 || n == 5) && this.installerState.isRespondedOverwriteNever()) {
                Logger.getInstance().info(null, "Don't overwrite because file exists (ron: " + this.installerState.isRespondedOverwriteNever() + ")");
                return false;
            }
            boolean bl3 = bl2 = n != 4 && n != 5;
            if (n == 2 || n == 3) {
                boolean bl4 = InstallHelper.isFirstFileNewer(file, installFile);
                if (!bl4 && (n == 2 || this.installerState.isRespondedOverwriteNever())) {
                    Logger.getInstance().info(null, "Don't overwrite because existing file is newer (ron: " + this.installerState.isRespondedOverwriteNever() + ")");
                    return false;
                }
                bl2 = bl4;
            }
            if (n == 1 || this.installerState.isRespondedOverwriteAlways() || bl && n != 5) {
                bl2 = true;
            }
            if (!bl2) {
                switch (progressInterface.askOverwrite(installFile)) {
                    case 4: {
                        this.installerState.setRespondedOverwriteNever(true);
                        Logger.getInstance().info(null, "Don't overwrite because of user action (never)");
                        return false;
                    }
                    case 1: {
                        Logger.getInstance().info(null, "Don't overwrite because of user action (no)");
                        return false;
                    }
                    case 3: {
                        this.installerState.setRespondedOverwriteAlways(true);
                    }
                }
            }
            BackupPair backupPair = this.backupFile(installFile);
            backupPair.setPreviouslyCreated(bl);
        } else {
            this.installerState.addCreatedFile(installFile, true);
        }
        return true;
    }

    public void registerUninstallFile(File file) {
        InstallFile installFile = new InstallFile(file, false);
        if (file.isDirectory()) {
            this.installerState.addCreatedDir(installFile);
        } else {
            this.installerState.addCreatedFile(installFile, true);
        }
    }

    public void createDirectory(File file, UninstallMode uninstallMode) {
        File file2;
        int n;
        Serializable serializable;
        try {
            file = file.getCanonicalFile();
        }
        catch (IOException iOException) {
            Logger.getInstance().log(iOException);
        }
        ArrayList<File> arrayList = new ArrayList<File>();
        for (serializable = file.getParentFile(); serializable != null; serializable = ((File)serializable).getParentFile()) {
            arrayList.add((File)serializable);
        }
        serializable = InstallHelper.getParentUninstallMode(uninstallMode);
        for (n = arrayList.size() - 1; n >= 0; --n) {
            file2 = (File)arrayList.get(n);
            boolean bl = file2.mkdir();
            if (!bl && serializable != UninstallMode.ALWAYS && serializable != UninstallMode.ALWAYS_BUT_NOT_FOR_UPDATE) continue;
            InstallFile installFile = new InstallFile(file2, false, (UninstallMode)serializable);
            this.installerState.addCreatedDir(installFile);
        }
        n = file.mkdir() ? 1 : 0;
        if (n != 0 || uninstallMode == UninstallMode.ALWAYS || uninstallMode == UninstallMode.ALWAYS_BUT_NOT_FOR_UPDATE) {
            file2 = new InstallFile(file, false, uninstallMode);
            this.installerState.addCreatedDir((InstallFile)file2);
        }
    }

    public void createDirectory(File file) {
        this.createDirectory(file, UninstallMode.IF_CREATED);
    }

    public boolean install(File file, File file2) throws UserCanceledException {
        return this.install(file, file2, new FileOptions(file.lastModified()));
    }

    public boolean install(File file, File file2, FileOptions fileOptions) throws UserCanceledException {
        return this.install(file, file2, fileOptions, null);
    }

    public boolean install(File file, File file2, FileOptions fileOptions, ProgressInterface progressInterface) throws UserCanceledException {
        if (progressInterface == null) {
            progressInterface = this.defaultProgressInterface;
        }
        boolean bl = false;
        try {
            BufferedInputStream bufferedInputStream = new BufferedInputStream(new FileInputStream(file));
            bl = this.install(bufferedInputStream, file2, fileOptions, progressInterface, file.length(), false);
            ((InputStream)bufferedInputStream).close();
        }
        catch (IOException iOException) {
            iOException.printStackTrace();
            String string = MessageFormat.format(Messages.getMessages().getString("ErrorInternal2"), "Could not read " + file);
            progressInterface.showFailure(string);
        }
        return bl;
    }

    public boolean install(InputStream inputStream, File file, FileOptions fileOptions) throws UserCanceledException, ReadIOException {
        return this.install(inputStream, file, fileOptions, null, 0L, false);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * WARNING - Removed back jump from a try to a catch block - possible behaviour change.
     * Unable to fully structure code
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public boolean install(InputStream var1_1, File var2_2, FileOptions var3_3, ProgressInterface var4_4, long var5_5, boolean var7_6) throws UserCanceledException, ReadIOException {
        block39: {
            block44: {
                block40: {
                    block41: {
                        block42: {
                            block43: {
                                if (var4_4 == null) {
                                    var4_4 = this.defaultProgressInterface;
                                }
                                if ((var8_7 = ContextImpl.getSingleContextInt()) != null) {
                                    var8_7.fireInstallerEvent(new InstallerFileEvent(var8_7.getEventSource(), var8_7, EventType.BEFORE_INSTALL_FILE, var2_2, var5_5));
                                }
                                var9_8 = var3_3.toString();
                                if (this.lastOptionsVerbose == null || !this.lastOptionsVerbose.equals(var9_8)) {
                                    Logger.getInstance().info(null, "File options set to: [" + var9_8 + "]");
                                    this.lastOptionsVerbose = var9_8;
                                }
                                var10_9 = false;
                                try {
                                    var11_10 = false;
                                    var12_11 = false;
                                    var13_12 = true;
lbl14:
                                    // 6 sources

                                    while (var13_12 && !var12_11 && !var10_9) {
                                        try {
                                            this.createDirectory(var2_2.getParentFile(), InstallHelper.getParentUninstallMode(var3_3.getUninstallMode()));
                                            var14_13 = File.createTempFile("i4j", null, var2_2.getParentFile());
                                            var15_16 = new ProgressAdapter(var4_4, false);
                                            var16_17 = var2_2.getName().endsWith(".jar");
                                            if (var7_6 && var16_17) {
                                                var15_16.setMaxCopyProgress(var5_5 * 3L);
                                            } else {
                                                var15_16.setMaxCopyProgress(var5_5);
                                            }
                                            if (!var2_2.getName().toLowerCase().endsWith(".exe") && !var2_2.getName().toLowerCase().endsWith(".dll")) ** GOTO lbl56
                                            if (!FileUtil.extractFile(var1_1, var14_13, var5_5, var15_16, true)) {
                                                var14_13.delete();
                                                var17_19 = false;
                                                if (!var11_10) {
                                                    var14_13.delete();
                                                }
                                            }
                                            ** GOTO lbl-1000
                                            if (var8_7 == null) return var17_19;
                                            var8_7.fireInstallerEvent(new InstallerFileEvent(var8_7.getEventSource(), var8_7, EventType.AFTER_INSTALL_FILE, var10_9, var2_2, var5_5));
                                            return var17_19;
                                        }
                                        catch (IOException var14_14) {
                                            if (var14_14 instanceof ReadIOException) {
                                                throw (ReadIOException)var14_14;
                                            }
                                            System.err.println(var14_14.getMessage());
                                            switch (var4_4.askRetry(var2_2)) {
                                                case 1: {
                                                    var13_12 = false;
                                                    break;
                                                }
                                                case 3: {
                                                    throw new UserCanceledException();
                                                }
                                            }
                                        }
                                    }
                                    break block39;
                                }
                                catch (Throwable var22_27) {
                                    if (var8_7 == null) throw var22_27;
                                    var8_7.fireInstallerEvent(new InstallerFileEvent(var8_7.getEventSource(), var8_7, EventType.AFTER_INSTALL_FILE, var10_9, var2_2, var5_5));
                                    throw var22_27;
                                }
lbl-1000:
                                // 1 sources

                                {
                                    var12_11 = true;
lbl56:
                                    // 2 sources

                                    var14_13.setLastModified(var3_3.getFileTime());
                                    var17_18 = new InstallFile(var2_2, var3_3.isShared(), var3_3.getUninstallMode());
                                    var18_20 = this.installerState.wasPreviouslyCreated(var2_2);
                                    if (!this.checkFile(var14_13, var17_18, var3_3.getOverwriteMode().getIntValue(), var3_3.getUninstallMode(), var18_20, var4_4)) break block40;
                                    if (var12_11) break block41;
                                    if (FileUtil.extractFile(var1_1, var14_13, var5_5, var15_16, true)) break block42;
                                    var14_13.delete();
                                    var19_21 = false;
                                    if (var11_10) break block43;
                                    var14_13.delete();
                                }
                            }
                            if (var8_7 == null) return var19_21;
                            var8_7.fireInstallerEvent(new InstallerFileEvent(var8_7.getEventSource(), var8_7, EventType.AFTER_INSTALL_FILE, var10_9, var2_2, var5_5));
                            return var19_21;
                        }
                        ** try [egrp 7[TRYBLOCK] [4 : 469->898)] { 
lbl75:
                        // 1 sources

                        var14_13.setLastModified(var3_3.getFileTime());
                        var12_11 = true;
                    }
                    if (var7_6 && var16_17) {
                        var19_22 = File.createTempFile("i4j", null, var2_2.getParentFile());
                        try {
                            if (!VersionSpecificHelper.unpack(var14_13, var19_22, var15_16)) {
                                FileUtil.rename(var14_13, var19_22);
                            }
                        }
                        catch (IOException var20_25) {
                            Logger.getInstance().log(var20_25);
                            var4_4.showFailure("Corrupted .pack file for " + var2_2.getPath() + ".\nPossibly the minimum Java version requirement for this installer has not been configured correctly.");
                            throw var20_25;
                        }
                        var14_13.delete();
                        var14_13 = var19_22;
                    }
                    var19_21 = true;
                    while (var19_21 && !var10_9) {
                        try {
                            InstallHelper.copyTemp(var14_13, var17_18, var3_3);
                            var10_9 = true;
                        }
                        catch (IOException var20_24) {
                            if (InstallerUtil.isWindows() && Util.hasFullAdminRights() && var3_3.isDelayIfNecessary()) {
                                var11_10 = true;
                                var10_9 = true;
                                this.installerState.addCreatedFile(new InstallFile(var14_13, false, UninstallMode.ALWAYS), false);
                                WinFileSystem.moveWithDelayUntilReboot(var17_18, null);
                                WinFileSystem.moveWithDelayUntilReboot(var14_13, var17_18);
                                this.installerState.setCurrentRebootRequired(true);
                                var8_7.setVariable("sys.rebootRequired", Boolean.TRUE);
                                Logger.getInstance().info(null, "Delayed installation of " + var2_2.getPath() + " from " + var14_13.getPath() + " until reboot.");
                                continue;
                            }
                            System.err.println(var20_24.getMessage());
                            switch (var4_4.askRetry(var17_18)) {
                                case 1: {
                                    var19_21 = false;
                                    break;
                                }
                                case 3: {
                                    throw new UserCanceledException();
                                }
                            }
                        }
                    }
                    break block44;
                }
                Logger.getInstance().info(null, "Did not replace " + var2_2.getPath());
                var10_9 = true;
                if (var3_3.isShared() && !var18_20 && (var3_3.getUninstallMode() == UninstallMode.ALWAYS || var3_3.getUninstallMode() == UninstallMode.ALWAYS_BUT_NOT_FOR_UPDATE)) {
                    this.installerState.addCreatedFile(var17_18, false);
                }
            }
            if (!var3_3.isShared() || var18_20) ** GOTO lbl14
            InstallHelper.registerShared(var2_2);
            ** GOTO lbl14
lbl129:
            // 1 sources

            finally {
                if (var11_10) ** GOTO lbl14
                var14_13.delete();
            }
        }
        if (!var10_9) {
            Logger.getInstance().error(null, "Could not write " + var2_2.getPath());
        }
        var14_15 = var10_9;
        if (var8_7 == null) return var14_15;
        var8_7.fireInstallerEvent(new InstallerFileEvent(var8_7.getEventSource(), var8_7, EventType.AFTER_INSTALL_FILE, var10_9, var2_2, var5_5));
        return var14_15;
    }

    public void setDefaultProgressInterface(ProgressInterface progressInterface) {
        this.defaultProgressInterface = new ProgressAdapter(progressInterface, true);
    }

    public void setRollbackBarrier() {
        this.installerState.setRollbackBarrier();
    }

    public void setLogDir(File file) {
        this.installerState.setLogDir(file);
    }

    public void writeLog() throws IOException, UserCanceledException {
        this.installerState.writeLog();
    }

    public boolean wasPreviouslyCreated(File file) {
        return this.installerState.wasPreviouslyCreated(file);
    }

    public boolean hasRollbackFiles() {
        return this.installerState.hasRollbackFiles();
    }

    public boolean hasUnrollbackedFiles() {
        return this.installerState.hasUnrollbackedFiles();
    }

    public void registerCleanupFile(File file) {
        this.installerState.registerCleanupFile(file);
    }

    public void cleanup() {
        HelperCommunication.getInstance().executeAction(ExecutionContext.MAXIMUM, new RunAction(){

            protected void run(Context context) {
                FileInstaller.getInstance().getFileRemover().cleanup(context.getProgressInterface());
            }
        });
    }

    public void finishUninstall() {
        HelperCommunication.getInstance().executeAction(ExecutionContext.MAXIMUM, new RunAction(){

            protected void run(Context context) {
                try {
                    FileInstaller.getInstance().getFileRemover().finishUninstall();
                }
                catch (IOException iOException) {
                    iOException.printStackTrace();
                }
            }
        });
    }

    public void deleteFile(final File file) {
        HelperCommunication.getInstance().executeAction(ExecutionContext.MAXIMUM, new RunAction(){

            protected void run(Context context) {
                FileInstaller.getInstance().getFileRemover().deleteFile(file);
            }
        });
    }

    public void uninstall(final boolean bl) throws IOException, UserCanceledException {
        HelperCommunication.getInstance().executeActionChecked(ExecutionContext.MAXIMUM, new RunAction(){

            protected void run(Context context) {
                try {
                    FileInstaller.getInstance().getFileRemover().uninstall(context.getProgressInterface(), bl);
                }
                catch (IOException iOException) {
                    throw new RuntimeException(iOException);
                }
            }
        });
    }

    public void rollback() {
        HelperCommunication.getInstance().executeAction(ExecutionContext.MAXIMUM, new RunAction(){

            protected void run(Context context) {
                FileInstaller.getInstance().getFileRemover().rollback(context.getProgressInterface());
            }
        });
    }

    public List deleteUndeleted() {
        return (List)HelperCommunication.getInstance().fetchObject(ExecutionContext.MAXIMUM, new FetchObjectAction(){

            protected Object fetchValue(Context context) throws UserCanceledException {
                return FileInstaller.getInstance().getFileRemover().deleteUndeleted();
            }
        });
    }

    public void resetCurrentRebootRequired() {
        this.installerState.setCurrentRebootRequired(false);
    }

    public boolean isCurrentRebootRequired() {
        return this.installerState.isCurrentRebootRequired();
    }
}

