/*
 * Decompiled with CFR 0.152.
 */
package com.install4j.runtime.installer.helper.fileinst;

import com.exe4j.runtime.util.FileUtil;
import com.exe4j.runtime.util.WinDel;
import com.install4j.api.Util;
import com.install4j.api.context.Context;
import com.install4j.api.context.ProgressInterface;
import com.install4j.api.context.UninstallMode;
import com.install4j.runtime.installer.ContextImpl;
import com.install4j.runtime.installer.ContextInt;
import com.install4j.runtime.installer.frontend.Messages;
import com.install4j.runtime.installer.helper.InstallerUtil;
import com.install4j.runtime.installer.helper.Logger;
import com.install4j.runtime.installer.helper.comm.ExecutionContext;
import com.install4j.runtime.installer.helper.comm.HelperCommunication;
import com.install4j.runtime.installer.helper.comm.actions.RunAction;
import com.install4j.runtime.installer.helper.fileinst.BackupPair;
import com.install4j.runtime.installer.helper.fileinst.FileInstallerState;
import com.install4j.runtime.installer.helper.fileinst.FileLogger;
import com.install4j.runtime.installer.helper.fileinst.InstallFile;
import com.install4j.runtime.installer.helper.fileinst.InstallHelper;
import com.install4j.runtime.installer.platform.unix.LegacyUnixFileSystem;
import java.io.File;
import java.io.IOException;
import java.io.Serializable;
import java.text.MessageFormat;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Set;
import java.util.StringTokenizer;

class FileRemover {
    public static final String DS_STORE_NAME = ".DS_Store";
    private List undeletedFiles = new ArrayList();
    private List undeletedDirs = new ArrayList();
    private boolean isUninstalling = false;
    private boolean uninstallForUpgrade = false;
    private Set parentFoldersOfDeletedFiles = new HashSet();
    private Set classPathFiles;

    FileRemover() {
    }

    public void rollback(ProgressInterface progressInterface) {
        this.rollback(progressInterface, FileInstallerState.getInstance().getRollbackFileLogger());
    }

    public void rollback(ProgressInterface progressInterface, FileLogger fileLogger) {
        Serializable serializable;
        int n = fileLogger.getCreatedFilesSize() + fileLogger.getCreatedDirsSize() + fileLogger.getReplacedFiles().size();
        int n2 = 0;
        for (int i = fileLogger.getReplacedFiles().size() - 1; i >= 0; --i) {
            serializable = (BackupPair)fileLogger.getReplacedFiles().get(i);
            n2 = FileRemover.restoreBackupFile(progressInterface, n, n2, (BackupPair)serializable);
        }
        Iterator iterator = fileLogger.getCreatedFilesIterator();
        while (iterator.hasNext()) {
            serializable = (InstallFile)iterator.next();
            if (!this.isUninstalling || ((InstallFile)serializable).checkUninstall(this.uninstallForUpgrade)) {
                if (((InstallFile)serializable).isShared()) {
                    if (InstallHelper.unregisterShared((File)serializable)) {
                        this.deleteFile((File)serializable);
                    }
                } else {
                    this.deleteFile((File)serializable);
                }
            }
            progressInterface.setPercentCompleted(++n2 * 100 / n);
        }
        iterator = fileLogger.getCreatedDirsIterator();
        while (iterator.hasNext()) {
            serializable = (InstallFile)iterator.next();
            if (!this.isUninstalling || ((InstallFile)serializable).checkUninstall(this.uninstallForUpgrade)) {
                this.deleteDir((File)serializable);
            }
            progressInterface.setPercentCompleted(++n2 * 100 / n);
        }
        this.deleteParentFolders();
    }

    private static int restoreBackupFile(ProgressInterface progressInterface, int n, int n2, final BackupPair backupPair) {
        ExecutionContext executionContext = backupPair.isElevated() ? ExecutionContext.MAXIMUM : ExecutionContext.UNELEVATED;
        try {
            HelperCommunication.getInstance().executeActionChecked(executionContext, new RunAction(){

                protected void run(Context context) {
                    try {
                        backupPair.getOriginalFile().delete();
                        if (!backupPair.getBackupFile().renameTo(backupPair.getOriginalFile())) {
                            FileUtil.copyFile(backupPair.getBackupFile(), backupPair.getOriginalFile());
                        }
                        backupPair.getOriginalFile().setLastModified(backupPair.getModTime());
                    }
                    catch (IOException iOException) {
                        // empty catch block
                    }
                }
            });
        }
        catch (Exception exception) {
            String string = MessageFormat.format(Messages.getMessages().getString("ErrorInternal2"), "Could not restore " + backupPair.getOriginalFile());
            progressInterface.showFailure(string);
        }
        progressInterface.setPercentCompleted(++n2 * 100 / n);
        return n2;
    }

    public void finishUninstall() throws IOException {
        if (InstallerUtil.isWindows() && (this.undeletedFiles.size() > 0 || this.undeletedDirs.size() > 0)) {
            if (WinDel.isUsed()) {
                WinDel.scheduleDeletion(this.undeletedFiles, this.undeletedDirs, true);
            } else {
                WinDel.setUsed(true);
                Runtime.getRuntime().addShutdownHook(new Thread("temp_deletion_starter"){

                    public void run() {
                        try {
                            WinDel.scheduleDeletion(FileRemover.this.undeletedFiles, FileRemover.this.undeletedDirs, false);
                        }
                        catch (IOException iOException) {
                            // empty catch block
                        }
                    }
                });
            }
        }
    }

    private void deleteParentFolders() {
        ContextInt contextInt = ContextImpl.getSingleContextInt();
        ArrayList arrayList = new ArrayList(this.parentFoldersOfDeletedFiles);
        Collections.sort(arrayList);
        for (int i = arrayList.size() - 1; i >= 0; --i) {
            File file = (File)arrayList.get(i);
            if (!FileUtil.isContainedInOrEquals(file, contextInt.getInstallationDirectory())) continue;
            this.preDeleteDir(file);
            if (file.delete() || !file.exists() || !Util.isWindows() || this.undeletedDirs.contains(file)) continue;
            this.undeletedDirs.add(file);
        }
    }

    public void deleteFile(File file) {
        if (!this.handleClassPathFile(file) && !this.doDeleteFile(file)) {
            this.undeletedFiles.add(file);
        }
        this.parentFoldersOfDeletedFiles.add(file.getParentFile());
    }

    private boolean doDeleteFile(File file) {
        if (!file.delete() && !Util.isWindows() && file.exists()) {
            System.setProperty("install4j.noDefaultChmod", "false");
            LegacyUnixFileSystem.setMode(file.isDirectory() ? "755" : "644", file);
            if (file.delete()) {
                return true;
            }
        }
        return !file.exists();
    }

    private void deleteDir(File file) {
        this.preDeleteDir(file);
        if (!file.delete() && file.exists()) {
            this.undeletedDirs.add(file);
        }
        this.parentFoldersOfDeletedFiles.add(file.getParentFile());
    }

    private void preDeleteDir(File file) {
        File[] fileArray;
        if (InstallerUtil.isMacOS() && file.exists() && (fileArray = file.listFiles()) != null && fileArray.length == 1 && fileArray[0].getName().equals(DS_STORE_NAME)) {
            fileArray[0].delete();
        }
    }

    public void cleanup(ProgressInterface progressInterface) {
        List list = FileInstallerState.getInstance().getReplacedFiles();
        for (int i = 0; i < list.size(); ++i) {
            BackupPair backupPair = (BackupPair)list.get(i);
            backupPair.getBackupFile().delete();
            progressInterface.setPercentCompleted((i + 1) * 100 / list.size());
        }
        List list2 = FileInstallerState.getInstance().getCleanupFiles();
        for (int i = 0; i < list2.size(); ++i) {
            ((File)list2.get(i)).delete();
        }
        this.deleteUndeleted();
    }

    public List deleteUndeleted() {
        this.doDeleteUndeleted();
        if (this.undeletedDirs.size() > 0 || this.undeletedFiles.size() > 0) {
            try {
                Thread.sleep(1000L);
            }
            catch (InterruptedException interruptedException) {
                interruptedException.printStackTrace();
            }
            this.doDeleteUndeleted();
        }
        ArrayList arrayList = new ArrayList(this.undeletedDirs);
        arrayList.addAll(this.undeletedFiles);
        return arrayList;
    }

    public void doDeleteUndeleted() {
        File file;
        Iterator iterator = this.undeletedFiles.iterator();
        while (iterator.hasNext()) {
            file = (File)iterator.next();
            if (!this.doDeleteFile(file)) continue;
            iterator.remove();
        }
        iterator = this.undeletedDirs.iterator();
        while (iterator.hasNext()) {
            file = (File)iterator.next();
            if (!this.doDeleteFile(file)) continue;
            iterator.remove();
        }
        this.deleteParentFolders();
    }

    public void uninstall(ProgressInterface progressInterface, boolean bl) throws IOException {
        File file = InstallerUtil.getInstallerFile("files.log");
        FileLogger fileLogger = new FileLogger();
        fileLogger.read(file);
        if (!bl) {
            this.deleteFile(file);
        }
        this.isUninstalling = true;
        this.uninstallForUpgrade = bl;
        if (InstallerUtil.isWindows()) {
            WinDel.prepareDeletion(InstallerUtil.getInstallerFile("i4jdel.exe"));
        }
        this.rollback(progressInterface, fileLogger);
        if (bl) {
            FileRemover.writeUninstallLog(fileLogger, file);
        }
    }

    private static void writeUninstallLog(FileLogger fileLogger, File file) throws IOException {
        File file2;
        HashSet hashSet = new HashSet();
        Iterator iterator = fileLogger.getCreatedFilesIterator();
        while (iterator.hasNext()) {
            file2 = (InstallFile)iterator.next();
            if (file2.getUninstallMode() == UninstallMode.IF_CREATED_BUT_NOT_FOR_UPDATE || file2.getUninstallMode() == UninstallMode.ALWAYS_BUT_NOT_FOR_UPDATE) {
                InstallHelper.addDirs(file2.getParentFile(), hashSet);
                continue;
            }
            iterator.remove();
        }
        iterator = fileLogger.getCreatedDirsIterator();
        while (iterator.hasNext()) {
            file2 = (InstallFile)iterator.next();
            if (file2.getUninstallMode() != UninstallMode.IF_CREATED_BUT_NOT_FOR_UPDATE && file2.getUninstallMode() != UninstallMode.ALWAYS_BUT_NOT_FOR_UPDATE) continue;
            InstallHelper.addDirs(file2, hashSet);
        }
        iterator = fileLogger.getCreatedDirsIterator();
        while (iterator.hasNext()) {
            file2 = (InstallFile)iterator.next();
            try {
                file2 = file2.getCanonicalFile();
            }
            catch (IOException iOException) {
                Logger.getInstance().log(iOException);
            }
            if (hashSet.contains(file2)) continue;
            iterator.remove();
        }
        fileLogger.write(file, null);
    }

    private boolean handleClassPathFile(File file) {
        if (this.classPathFiles == null) {
            this.classPathFiles = new HashSet();
            FileRemover.addFiles(this.classPathFiles, System.getProperty("java.class.path"));
            FileRemover.addFiles(this.classPathFiles, System.getProperty("sun.boot.class.path"));
        }
        try {
            file = file.getCanonicalFile();
        }
        catch (IOException iOException) {
            Logger.getInstance().log(iOException);
        }
        if (this.classPathFiles.contains(file)) {
            Logger.getInstance().info(this, "postponing deletion of " + file);
            this.undeletedFiles.add(file);
            return true;
        }
        return false;
    }

    private static void addFiles(Set set, String string) {
        StringTokenizer stringTokenizer = new StringTokenizer(string, File.pathSeparator);
        while (stringTokenizer.hasMoreTokens()) {
            File file = new File(stringTokenizer.nextToken());
            try {
                file = file.getCanonicalFile();
            }
            catch (IOException iOException) {
                Logger.getInstance().log(iOException);
            }
            set.add(file);
        }
    }
}

