/*
 * Decompiled with CFR 0.152.
 */
package com.install4j.runtime.installer.helper.fileinst;

import com.exe4j.runtime.util.FileUtil;
import com.install4j.api.context.FileOptions;
import com.install4j.api.context.UninstallMode;
import com.install4j.api.windows.RegistryRoot;
import com.install4j.api.windows.WinRegistry;
import com.install4j.runtime.installer.helper.InstallerUtil;
import com.install4j.runtime.installer.helper.Logger;
import com.install4j.runtime.installer.helper.versionspecific.VersionSpecificHelper;
import com.install4j.runtime.installer.platform.win32.FileVersion;
import java.io.File;
import java.io.IOException;
import java.util.Set;

class InstallHelper {
    private static final String KEY_SHARED_DLLS = "SOFTWARE\\Microsoft\\Windows\\CurrentVersion\\SharedDLLs";
    private static final boolean DISABLE_WINDOWS_VERSION_COMPARISON = Boolean.getBoolean("install4j.disableWinVersionComparison");

    InstallHelper() {
    }

    private static Object addSharedCount(Object object, int n) {
        int n2 = 1;
        try {
            if (object instanceof Integer) {
                n2 = (Integer)object + n;
                object = new Integer(n2);
            } else if (object instanceof String) {
                n2 = Integer.parseInt((String)object) + n;
                object = String.valueOf(n2);
            } else if (object instanceof byte[]) {
                byte[] byArray = (byte[])object;
                if (byArray.length < 1 || byArray.length > 4) {
                    throw new NumberFormatException();
                }
                int[] nArray = new int[4];
                for (int i = 0; i < byArray.length; ++i) {
                    nArray[i] = byArray[i];
                }
                n2 = (nArray[3] << 24) + (nArray[2] << 16) + (nArray[1] << 8) + (nArray[0] << 0);
                byArray[0] = (byte)((n2 += n) >>> 0 & 0xFF);
                byArray[1] = (byte)(n2 >>> 8 & 0xFF);
                byArray[2] = (byte)(n2 >>> 16 & 0xFF);
                byArray[3] = (byte)(n2 >>> 24 & 0xFF);
            }
        }
        catch (NumberFormatException numberFormatException) {
            object = new Integer(n2);
        }
        if (n2 <= 0) {
            return null;
        }
        return object;
    }

    static void registerShared(File file) {
        if (!InstallerUtil.isWindows()) {
            return;
        }
        Object object = WinRegistry.getValue(RegistryRoot.HKEY_LOCAL_MACHINE, KEY_SHARED_DLLS, file.getAbsolutePath());
        if (object == null) {
            object = new Integer(0);
        }
        object = InstallHelper.addSharedCount(object, 1);
        WinRegistry.setValue(RegistryRoot.HKEY_LOCAL_MACHINE, KEY_SHARED_DLLS, file.getAbsolutePath(), object);
    }

    static boolean unregisterShared(File file) {
        if (!InstallerUtil.isWindows()) {
            return true;
        }
        Object object = WinRegistry.getValue(RegistryRoot.HKEY_LOCAL_MACHINE, KEY_SHARED_DLLS, file.getAbsolutePath());
        if (object == null) {
            return true;
        }
        if ((object = InstallHelper.addSharedCount(object, -1)) == null) {
            WinRegistry.deleteValue(RegistryRoot.HKEY_LOCAL_MACHINE, KEY_SHARED_DLLS, file.getAbsolutePath());
            return true;
        }
        WinRegistry.setValue(RegistryRoot.HKEY_LOCAL_MACHINE, KEY_SHARED_DLLS, file.getAbsolutePath(), object);
        return false;
    }

    static UninstallMode getParentUninstallMode(UninstallMode uninstallMode) {
        if (uninstallMode == UninstallMode.ALWAYS) {
            return UninstallMode.IF_CREATED;
        }
        if (uninstallMode == UninstallMode.ALWAYS_BUT_NOT_FOR_UPDATE) {
            return UninstallMode.IF_CREATED_BUT_NOT_FOR_UPDATE;
        }
        return uninstallMode;
    }

    static void addDirs(File file, Set set) {
        if (file != null) {
            try {
                file = file.getCanonicalFile();
            }
            catch (IOException iOException) {
                Logger.getInstance().log(iOException);
            }
            set.add(file);
            InstallHelper.addDirs(file.getParentFile(), set);
        }
    }

    static boolean isFirstFileNewer(File file, File file2) {
        if (InstallerUtil.isWindows() && !DISABLE_WINDOWS_VERSION_COMPARISON) {
            int n = FileVersion.compare(file, file2);
            if (n == 1) {
                Logger.getInstance().info(null, "Windows version info marks file as newer.");
                return true;
            }
            if (n == 3) {
                Logger.getInstance().info(null, "File times: " + file.lastModified() + ", " + file2.lastModified());
                return file.lastModified() > file2.lastModified();
            }
            Logger.getInstance().info(null, "Windows version info marks file as older.");
            return false;
        }
        Logger.getInstance().info(null, "File times: " + file.lastModified() + ", " + file2.lastModified());
        return file.lastModified() > file2.lastModified();
    }

    static void copyTemp(File file, File file2, FileOptions fileOptions) throws IOException {
        if (file2.exists() && !file2.delete()) {
            throw new IOException("could not delete " + file2);
        }
        FileUtil.rename(file, file2);
        file2.setLastModified(fileOptions.getFileTime());
        if (!InstallerUtil.isWindows()) {
            VersionSpecificHelper.setPosixFilePermissions(file2, fileOptions.getMode());
        }
    }
}

