
/*
 * Copyright (c) MuleSoft, Inc.  All rights reserved.  http://www.mulesoft.com
 * The software in this package is published under the terms of the CPAL v1.0
 * license, a copy of which has been included with this distribution in the
 * LICENSE.txt file.
 */

package org.mule.tooling.agent.rest.client.tooling.applications.applicationId.flows;

import org.mule.tooling.agent.rest.client.tooling.applications.applicationId.flows.flowname.FlowName;

import javax.ws.rs.client.Client;

/**
 * Flows web resource.
 *
 * @since 4.0
 */
public class Flows {

  private String baseUrl;
  private Client client;

  public Flows(String baseUrl, Client client) {
    this.baseUrl = (baseUrl + "/flows");
    this.client = client;
  }

  private Client getClient() {
    return this.client;
  }

  private String getBaseUri() {
    return baseUrl;
  }

  /**
   * Access to the flow resource.
   *
   * @param flowName the name of the flow.
   * @return {@link FlowName} to operate with.
   */
  public final FlowName flowName(String flowName) {
    return new FlowName(getBaseUri(), getClient(), flowName);
  }

}
