/*
 * Copyright (c) MuleSoft, Inc.  All rights reserved.  http://www.mulesoft.com
 * The software in this package is published under the terms of the CPAL v1.0
 * license, a copy of which has been included with this distribution in the
 * LICENSE.txt file.
 */

package org.mule.tooling.agent.rest.client.tooling.applications.applicationName.tryIt;

import org.mule.tooling.event.model.EventModel;
import org.mule.tooling.event.model.component.location.ComponentLocation;

import com.fasterxml.jackson.annotation.JsonIgnoreProperties;

import java.util.List;
import java.util.Map;

import org.apache.commons.lang.builder.ReflectionToStringBuilder;

/**
 * DTO for {@link com.mulesoft.agent.domain.tracking.AgentTrackingNotification} from Mule Runtime Agent.
 *
 * @since 4.0
 */
@JsonIgnoreProperties(ignoreUnknown = true)
public class AgentTrackingNotificationResponse {

  private String application;
  private long timestamp;
  private String notificationType;
  private String pipelineType;
  private String action;
  private String resourceIdentifier;
  private String source;
  private ComponentLocation componentLocation;
  private List<String> annotations;
  private String correlationId;
  private String transactionId;
  private String parentBranchId;
  private String branchId;
  private Map<String, String> customEventProperties;
  private String customEventName;
  private EventModel event;


  public String getApplication() {
    return application;
  }

  public void setApplication(String application) {
    this.application = application;
  }

  public long getTimestamp() {
    return timestamp;
  }

  public void setTimestamp(long timestamp) {
    this.timestamp = timestamp;
  }

  public String getNotificationType() {
    return notificationType;
  }

  public void setNotificationType(String notificationType) {
    this.notificationType = notificationType;
  }

  public String getPipelineType() {
    return pipelineType;
  }

  public void setPipelineType(String pipelineType) {
    this.pipelineType = pipelineType;
  }

  public String getAction() {
    return action;
  }

  public void setAction(String action) {
    this.action = action;
  }

  public String getResourceIdentifier() {
    return resourceIdentifier;
  }

  public void setResourceIdentifier(String resourceIdentifier) {
    this.resourceIdentifier = resourceIdentifier;
  }

  public String getSource() {
    return source;
  }

  public void setSource(String source) {
    this.source = source;
  }

  public ComponentLocation getComponentLocation() {
    return componentLocation;
  }

  public void setComponentLocation() {
    this.componentLocation = componentLocation;
  }

  public List<String> getAnnotations() {
    return annotations;
  }

  public void setAnnotations(List<String> annotations) {
    this.annotations = annotations;
  }

  public String getCorrelationId() {
    return correlationId;
  }

  public void setCorrelationId(String correlationId) {
    this.correlationId = correlationId;
  }

  public String getTransactionId() {
    return transactionId;
  }

  public void setTransactionId(String transactionId) {
    this.transactionId = transactionId;
  }

  public Map<String, String> getCustomEventProperties() {
    return customEventProperties;
  }

  public void setCustomEventProperties(Map<String, String> customEventProperties) {
    this.customEventProperties = customEventProperties;
  }

  public String getCustomEventName() {
    return customEventName;
  }

  public void setCustomEventName(String customEventName) {
    this.customEventName = customEventName;
  }

  public String getBranchId() {
    return branchId;
  }

  public void setBranchId(String branchId) {
    this.branchId = branchId;
  }

  public String getParentBranchId() {
    return parentBranchId;
  }

  public void setParentBranchId(String parentBranchId) {
    this.parentBranchId = parentBranchId;
  }

  public EventModel getEvent() {
    return event;
  }

  public void setEvent(EventModel eventModelModel) {
    this.event = eventModelModel;
  }

  @Override
  public String toString() {
    return ReflectionToStringBuilder.toString(this);
  }
}
