/*
 * Decompiled with CFR 0.152.
 */
package org.mule.tooling.agent.rest.client;

import com.mulesoft.agent.domain.tooling.BundleDescriptor;
import com.mulesoft.agent.domain.tooling.dataweave.model.PreviewRequest;
import com.mulesoft.agent.domain.tooling.dataweave.model.PreviewResponse;
import com.mulesoft.agent.external.handlers.tooling.TestConnectionRequest;
import java.io.File;
import java.io.InputStream;
import java.net.ConnectException;
import java.net.URL;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import javax.net.ssl.SSLContext;
import javax.ws.rs.ProcessingException;
import javax.ws.rs.client.Client;
import javax.ws.rs.client.ClientBuilder;
import org.apache.commons.lang3.ClassUtils;
import org.mule.runtime.api.app.declaration.ArtifactDeclaration;
import org.mule.runtime.api.meta.model.ComponentModel;
import org.mule.runtime.api.meta.model.operation.OperationModel;
import org.mule.runtime.api.meta.model.source.SourceModel;
import org.mule.runtime.api.metadata.MetadataKeysContainer;
import org.mule.runtime.api.metadata.descriptor.ComponentMetadataDescriptor;
import org.mule.runtime.api.metadata.resolving.MetadataResult;
import org.mule.tooling.agent.RuntimeToolingService;
import org.mule.tooling.agent.rest.client.ImmutableConnectionValidationResult;
import org.mule.tooling.agent.rest.client.api.ToolingServiceAPIClient;
import org.mule.tooling.agent.rest.client.exceptions.ToolingServiceAPIException;
import org.mule.tooling.agent.rest.client.exceptions.model.ErrorCode;
import org.mule.tooling.agent.rest.client.tooling.applications.applicationId.components.componentId.connection.model.ConnectivityTestingResponse;
import org.mule.tooling.agent.rest.client.tooling.applications.applicationName.tryIt.AgentTrackingNotificationResponse;
import org.mule.tooling.agent.rest.client.tooling.applications.model.ApplicationsPUTBody;
import org.mule.tooling.client.api.connectivity.BundleNotFoundException;
import org.mule.tooling.client.api.connectivity.ConnectionValidationResult;
import org.mule.tooling.client.api.connectivity.ConnectivityTestingObjectNotFoundException;
import org.mule.tooling.client.api.connectivity.UnsupportedConnectivityTestingObjectException;
import org.mule.tooling.client.api.exception.DeploymentException;
import org.mule.tooling.client.api.exception.NoSuchApplicationException;
import org.mule.tooling.client.api.exception.ServiceUnavailableException;
import org.mule.tooling.client.api.exception.ToolingException;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class RestAgentToolingService
implements RuntimeToolingService {
    private final Logger logger = LoggerFactory.getLogger(this.getClass());
    private ToolingServiceAPIClient client;
    private URL url;
    private static boolean VERBOSE_ERROR_ENABLED = true;
    private Optional<SSLContext> sslContextOptional;

    @Override
    public void setToolingApiUrl(URL url, int defaultConnectTimeout, int defaultReadTimeout, Optional<SSLContext> sslContext) {
        Objects.requireNonNull(url, "url cannot be null");
        if (this.logger.isDebugEnabled()) {
            this.logger.debug("Configuring using tooling API URL:{}, defaultConnectTimeout:{}ms, defaultReadTimeout:{}ms", new Object[]{url, defaultConnectTimeout, defaultReadTimeout});
        }
        this.sslContextOptional = sslContext;
        this.client = ToolingServiceAPIClient.create(url.toString(), defaultConnectTimeout, defaultReadTimeout, sslContext);
        this.url = url;
    }

    @Override
    public boolean isOperational() {
        ClientBuilder builder = ClientBuilder.newBuilder();
        this.sslContextOptional.ifPresent(sslContext -> builder.sslContext(sslContext));
        Client client = builder.build();
        try {
            client.target(this.url.toString()).request().buildGet().invoke();
            return true;
        }
        catch (ProcessingException e) {
            if (e.getCause() instanceof ConnectException) {
                return false;
            }
            throw e;
        }
    }

    @Override
    public String deployApplication(File appLocation) {
        if (this.logger.isDebugEnabled()) {
            this.logger.debug("PUT:tooling/applications appLocation:[{}]", (Object)appLocation);
        }
        try {
            return this.client.tooling.applications.put(new ApplicationsPUTBody(appLocation.getAbsolutePath()), VERBOSE_ERROR_ENABLED).getApplicationId();
        }
        catch (Exception e) {
            if (e.getCause() instanceof ConnectException) {
                throw new ServiceUnavailableException("Mule Agent REST service is not available", (Throwable)e);
            }
            throw new DeploymentException("Couldn't deploy the application", (Throwable)e);
        }
    }

    @Override
    public String deployApplication(InputStream inputStream) throws DeploymentException, ServiceUnavailableException {
        this.logger.debug("PUT:tooling/applications appLocation:[{}]");
        try {
            return this.client.tooling.applications.put(inputStream, VERBOSE_ERROR_ENABLED).getApplicationId();
        }
        catch (Exception e) {
            if (e.getCause() instanceof ConnectException) {
                throw new ServiceUnavailableException("Mule Agent REST service is not available", (Throwable)e);
            }
            throw new DeploymentException("Couldn't deploy the application", (Throwable)e);
        }
    }

    @Override
    public void disposeApplication(String applicationId) throws ServiceUnavailableException, ToolingException {
        if (this.logger.isDebugEnabled()) {
            this.logger.debug("DELETE:tooling/applications/{}", (Object)applicationId);
        }
        try {
            this.client.tooling.applications.applicationId(applicationId).delete(VERBOSE_ERROR_ENABLED);
        }
        catch (Exception e) {
            if (e.getCause() instanceof ConnectException) {
                throw new ServiceUnavailableException("Mule Agent REST service is not available", (Throwable)e);
            }
            throw new ToolingException("Couldn't dispose application, for applicationId: " + applicationId, (Throwable)e);
        }
    }

    @Override
    public ConnectionValidationResult testConnection(String applicationId, String componentId) throws NoSuchApplicationException, UnsupportedConnectivityTestingObjectException, ConnectivityTestingObjectNotFoundException, ServiceUnavailableException, ToolingException {
        if (this.logger.isDebugEnabled()) {
            this.logger.debug("GET:tooling/applications/{}/components/{}/connection", (Object)applicationId, (Object)componentId);
        }
        try {
            ConnectivityTestingResponse response = this.client.tooling.applications.applicationId((String)applicationId).components.componentId((String)componentId).connection.get(VERBOSE_ERROR_ENABLED);
            return response.getValidationStatus() != false ? ImmutableConnectionValidationResult.success() : ImmutableConnectionValidationResult.failure(response.getMessage(), response.getErrorType(), response.getException());
        }
        catch (ToolingServiceAPIException e) {
            return this.handleConnectivityTestingError(e);
        }
        catch (Exception e) {
            if (e.getCause() instanceof ConnectException) {
                throw new ServiceUnavailableException("Mule Agent REST service is not available", (Throwable)e);
            }
            throw new ToolingException("Error while deploying application", (Throwable)e);
        }
    }

    @Override
    public ConnectionValidationResult testConnection(List<BundleDescriptor> dependencies, ArtifactDeclaration artifactDeclaration, String componentId) throws UnsupportedConnectivityTestingObjectException, ConnectivityTestingObjectNotFoundException, ServiceUnavailableException, ToolingException {
        if (this.logger.isDebugEnabled()) {
            this.logger.debug("PUT:tooling/components/{}/connection", (Object)componentId);
        }
        try {
            ConnectivityTestingResponse response = this.client.tooling.components.componentId((String)componentId).connection.put(this.createRequest(dependencies, artifactDeclaration), VERBOSE_ERROR_ENABLED);
            return response.getValidationStatus() != false ? ImmutableConnectionValidationResult.success() : ImmutableConnectionValidationResult.failure(response.getMessage(), response.getErrorType(), response.getException());
        }
        catch (ToolingServiceAPIException e) {
            return this.handleConnectivityTestingError(e);
        }
        catch (Exception e) {
            if (e.getCause() instanceof ConnectException) {
                throw new ServiceUnavailableException("Mule Agent REST service is not available", (Throwable)e);
            }
            throw new ToolingException("Error while doing connectivity testing for a temporary application", (Throwable)e);
        }
    }

    @Override
    public PreviewResponse runDataWeave(String applicationId, PreviewRequest request) {
        if (this.logger.isDebugEnabled()) {
            this.logger.debug("POST:tooling/applications/{}/dataweave/execute", (Object)applicationId);
        }
        try {
            PreviewResponse response = this.client.tooling.applications.applicationId((String)applicationId).dataweave.execute.post(request, VERBOSE_ERROR_ENABLED);
            return response;
        }
        catch (Exception e) {
            if (e.getCause() instanceof ConnectException) {
                throw new ServiceUnavailableException("Mule Agent REST service is not available", (Throwable)e);
            }
            throw new ToolingException("Error while executing dataweave script for a temporary application", (Throwable)e);
        }
    }

    private TestConnectionRequest createRequest(List<BundleDescriptor> dependencies, ArtifactDeclaration artifactDeclaration) {
        TestConnectionRequest request = new TestConnectionRequest();
        request.setArtifactDeclaration(artifactDeclaration);
        request.setDependencies(dependencies);
        return request;
    }

    private ConnectionValidationResult handleConnectivityTestingError(ToolingServiceAPIException e) {
        ErrorCode errorCode = e.getErrorCode();
        if (errorCode == null) {
            throw new ToolingException("Internal server error while doing connectivity testing", (Throwable)e);
        }
        if (errorCode == ErrorCode.NO_SUCH_APPLICATION) {
            throw new NoSuchApplicationException("Application resource not found", (Throwable)e);
        }
        if (errorCode == ErrorCode.BUNDLE_NOT_FOUND) {
            throw new BundleNotFoundException("Extension bundle not found", (Throwable)e);
        }
        if (errorCode == ErrorCode.CONNECTIVITY_TESTING_OBJECT_NOT_FOUND) {
            throw new ConnectivityTestingObjectNotFoundException("Component resource not found", (Throwable)e);
        }
        if (errorCode == ErrorCode.UNSUPPORTED_CONNECTIVITY_TESTING_OBJECT) {
            throw new UnsupportedConnectivityTestingObjectException("Component doesn't support connectivity testing", (Throwable)e);
        }
        if (errorCode == ErrorCode.UNKNOWN_ERROR) {
            throw new ToolingException("Unknown error while doing connectivity testing", (Throwable)e);
        }
        throw new ToolingException("Internal server error while doing connectivity testing for application", (Throwable)e);
    }

    @Override
    public MetadataResult<MetadataKeysContainer> getMetadataKeys(String applicationId, String componentLocation) throws ServiceUnavailableException, ToolingException {
        if (this.logger.isDebugEnabled()) {
            this.logger.debug("GET:tooling/applications/{}/components/{}/keys", (Object)applicationId, (Object)componentLocation);
        }
        try {
            return this.client.tooling.applications.applicationId((String)applicationId).components.componentId((String)componentLocation).keys.get(VERBOSE_ERROR_ENABLED);
        }
        catch (Exception e) {
            if (e.getCause() instanceof ConnectException) {
                throw new ServiceUnavailableException("Mule Agent REST service is not available", (Throwable)e);
            }
            throw new ToolingException("Error while getting Metadata keys", (Throwable)e);
        }
    }

    @Override
    public MetadataResult<ComponentMetadataDescriptor<OperationModel>> getOperationMetadata(String applicationId, String componentLocation) throws ServiceUnavailableException, ToolingException {
        return this.getMetadata(applicationId, componentLocation);
    }

    @Override
    public MetadataResult<ComponentMetadataDescriptor<SourceModel>> getSourceMetadata(String applicationId, String componentLocation) throws ServiceUnavailableException, ToolingException {
        return this.getMetadata(applicationId, componentLocation);
    }

    private <T extends ComponentModel> MetadataResult<ComponentMetadataDescriptor<T>> getMetadata(String applicationId, String componentLocation) {
        if (this.logger.isDebugEnabled()) {
            this.logger.debug("GET:tooling/applications/{}/components/{}/metadata", (Object)applicationId, (Object)componentLocation);
        }
        try {
            return this.client.tooling.applications.applicationId((String)applicationId).components.componentId((String)componentLocation).metadata.get(VERBOSE_ERROR_ENABLED);
        }
        catch (Exception e) {
            if (e.getCause() instanceof ConnectException) {
                throw new ServiceUnavailableException("Mule Agent REST service is not available", (Throwable)e);
            }
            throw new ToolingException("Error while getting Metadata", (Throwable)e);
        }
    }

    @Override
    public void enableTryIt(String applicationName) throws NoSuchApplicationException {
        if (this.logger.isDebugEnabled()) {
            this.logger.debug("PUT:tooling/applications/{}/tryit/", (Object)applicationName);
        }
        try {
            this.client.tooling.applications.applicationName((String)applicationName).tryIt.put(VERBOSE_ERROR_ENABLED);
        }
        catch (ToolingServiceAPIException e) {
            ErrorCode errorCode = e.getErrorCode();
            if (errorCode == ErrorCode.NO_SUCH_APPLICATION) {
                throw new NoSuchApplicationException("Application resource not found", (Throwable)e);
            }
            throw new ToolingException("Error while enabling application for TryIt", (Throwable)e);
        }
        catch (Exception e) {
            if (e.getCause() instanceof ConnectException) {
                throw new ServiceUnavailableException("Mule Agent REST service is not available", (Throwable)e);
            }
            throw new ToolingException("Error while enabling application for TryIt", (Throwable)e);
        }
    }

    @Override
    public List<AgentTrackingNotificationResponse> consumeTryItNotifications(String applicationName, int chunkSize) {
        if (this.logger.isDebugEnabled()) {
            this.logger.debug("GET:tooling/applications/{}/tryit/", (Object)applicationName);
        }
        try {
            return this.client.tooling.applications.applicationName((String)applicationName).tryIt.get(chunkSize, VERBOSE_ERROR_ENABLED);
        }
        catch (Exception e) {
            if (e.getCause() instanceof ConnectException) {
                throw new ServiceUnavailableException("Mule Agent REST service is not available", (Throwable)e);
            }
            throw new ToolingException("Error while getting application notifications for TryIt", (Throwable)e);
        }
    }

    @Override
    public void disableTryIt(String applicationName) {
        if (this.logger.isDebugEnabled()) {
            this.logger.debug("DELETE:tooling/applications/{}/tryit/", (Object)applicationName);
        }
        try {
            this.client.tooling.applications.applicationName((String)applicationName).tryIt.delete(VERBOSE_ERROR_ENABLED);
        }
        catch (Exception e) {
            if (e.getCause() instanceof ConnectException) {
                throw new ServiceUnavailableException("Mule Agent REST service is not available", (Throwable)e);
            }
            throw new ToolingException("Error while disabling application for TryIt", (Throwable)e);
        }
    }

    public String toString() {
        return String.format("%s{url=%s}", ClassUtils.getShortClassName(this.getClass()), this.url);
    }
}

