
/*
 * Copyright (c) MuleSoft, Inc.  All rights reserved.  http://www.mulesoft.com
 * The software in this package is published under the terms of the CPAL v1.0
 * license, a copy of which has been included with this distribution in the
 * LICENSE.txt file.
 */

package org.mule.tooling.agent.rest.client.tooling.applications.applicationId.components.componentId.keys;

import static javax.ws.rs.core.MediaType.APPLICATION_JSON_TYPE;
import static javax.ws.rs.core.Response.Status.Family.SUCCESSFUL;
import static org.mule.tooling.agent.rest.client.exceptions.ToolingServiceAPIException.newToolingServiceAPIException;
import static org.mule.tooling.agent.rest.client.tooling.Tooling.VERBOSE_QUERY_PARAM;
import org.mule.runtime.api.metadata.MetadataKeysContainer;
import org.mule.runtime.api.metadata.resolving.MetadataResult;
import org.mule.runtime.extension.api.persistence.metadata.MetadataKeysResultJsonSerializer;
import org.mule.tooling.agent.rest.client.exceptions.ToolingServiceAPIException;

import javax.ws.rs.client.Client;
import javax.ws.rs.client.WebTarget;
import javax.ws.rs.core.Response;

/**
 * Keys web resource.
 *
 * @since 4.0
 */
public class Keys {

  private String baseUrl;
  private Client client;

  public Keys(String baseUrl, Client client) {
    this.baseUrl = (baseUrl + "/keys");
    this.client = client;
  }

  private Client getClient() {
    return this.client;
  }

  private String getBaseUri() {
    return baseUrl;
  }

  /**
   * GET operation, gets Metadata Keys for the componentId of the application.
   *
   * @param verboseErrorsEnabled  flag that defines if it has to be verbose the response in case of errors/failures.
   * @return {@link MetadataResult<MetadataKeysContainer>} with the response.
   * @throws ToolingServiceAPIException if there was an error.
   */
  public MetadataResult<MetadataKeysContainer> get(boolean verboseErrorsEnabled) {
    WebTarget target = this.getClient().target(getBaseUri());
    target = target.queryParam(VERBOSE_QUERY_PARAM, verboseErrorsEnabled);
    final javax.ws.rs.client.Invocation.Builder invocationBuilder = target.request(APPLICATION_JSON_TYPE);
    Response response = invocationBuilder.get();
    if (response.getStatusInfo().getFamily() != SUCCESSFUL) {
      throw newToolingServiceAPIException(response);
    }
    //TODO MULE-10794 : Cannot reuse serializer between calls
    return new MetadataKeysResultJsonSerializer().deserialize(response.readEntity(String.class));
  }

}
