
/*
 * Copyright (c) MuleSoft, Inc.  All rights reserved.  http://www.mulesoft.com
 * The software in this package is published under the terms of the CPAL v1.0
 * license, a copy of which has been included with this distribution in the
 * LICENSE.txt file.
 */

package org.mule.tooling.agent.rest.client.tooling.applications.applicationName.tryIt;

import static javax.ws.rs.core.MediaType.APPLICATION_JSON_TYPE;
import static javax.ws.rs.core.Response.Status.Family.SUCCESSFUL;
import static org.mule.tooling.agent.rest.client.exceptions.ToolingServiceAPIException.newToolingServiceAPIException;
import static org.mule.tooling.agent.rest.client.tooling.Tooling.VERBOSE_QUERY_PARAM;
import org.mule.tooling.agent.rest.client.exceptions.ToolingServiceAPIException;

import java.util.List;

import javax.ws.rs.client.Client;
import javax.ws.rs.client.WebTarget;
import javax.ws.rs.core.GenericType;
import javax.ws.rs.core.Response;

/**
 * Keys web resource.
 *
 * @since 4.0
 */
public class TryIt {

  private static String CHUNK_SIZE_PARAM = "chunkSize";

  private String baseUrl;
  private Client client;

  public TryIt(String baseUrl, Client client) {
    this.baseUrl = baseUrl + "/tryit";
    this.client = client;
  }

  private Client getClient() {
    return this.client;
  }

  private String getBaseUri() {
    return baseUrl;
  }

  /**
   * GET operation, gets notifications for the application.
   *
   *
   * @param chunkSize
   * @param verboseErrorsEnabled  flag that defines if it has to be verbose the response in case of errors/failures.
   * @return {@link List<AgentTrackingNotificationResponse>} with the response.
   * @throws ToolingServiceAPIException if there was an error.
   */
  public List<AgentTrackingNotificationResponse> get(int chunkSize, boolean verboseErrorsEnabled) {
    WebTarget target = this.getClient().target(getBaseUri());
    target = target.queryParam(CHUNK_SIZE_PARAM, chunkSize);
    target = target.queryParam(VERBOSE_QUERY_PARAM, verboseErrorsEnabled);
    final javax.ws.rs.client.Invocation.Builder invocationBuilder = target.request(APPLICATION_JSON_TYPE);
    Response response = invocationBuilder.get();
    if (response.getStatusInfo().getFamily() != SUCCESSFUL) {
      throw newToolingServiceAPIException(response);
    }
    return response.readEntity(new GenericType<List<AgentTrackingNotificationResponse>>() {});
  }

  /**
   * PUT operation for try it resource that enables the service for the given application name.
   * @param verboseErrorsEnabled flag that defines if it has to be verbose the response in case of errors/failures.
   */
  public void put(boolean verboseErrorsEnabled) {
    WebTarget target = this.getClient().target(getBaseUri());
    target = target.queryParam(VERBOSE_QUERY_PARAM, verboseErrorsEnabled);
    final javax.ws.rs.client.Invocation.Builder invocationBuilder = target.request(APPLICATION_JSON_TYPE);
    Response response = invocationBuilder.put(javax.ws.rs.client.Entity.json(""));
    if (response.getStatusInfo().getFamily() != SUCCESSFUL) {
      throw newToolingServiceAPIException(response);
    }
    return;
  }

  /**
   * DELETE operation for try it resource that disables the service for the given application name.
   * @param verboseErrorsEnabled flag that defines if it has to be verbose the response in case of errors/failures.
   */
  public void delete(boolean verboseErrorsEnabled) {
    WebTarget target = this.getClient().target(getBaseUri());
    target = target.queryParam(VERBOSE_QUERY_PARAM, verboseErrorsEnabled);
    final javax.ws.rs.client.Invocation.Builder invocationBuilder = target.request(APPLICATION_JSON_TYPE);
    Response response = invocationBuilder.delete();
    if (response.getStatusInfo().getFamily() != SUCCESSFUL) {
      throw newToolingServiceAPIException(response);
    }
    return;
  }

}
