
/*
 * Copyright (c) MuleSoft, Inc.  All rights reserved.  http://www.mulesoft.com
 * The software in this package is published under the terms of the CPAL v1.0
 * license, a copy of which has been included with this distribution in the
 * LICENSE.txt file.
 */

package org.mule.tooling.agent.rest.client.tooling.applications.model;

import static org.apache.commons.lang3.builder.ToStringBuilder.reflectionToString;

import com.fasterxml.jackson.annotation.JsonAnyGetter;
import com.fasterxml.jackson.annotation.JsonAnySetter;
import com.fasterxml.jackson.annotation.JsonIgnore;
import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonPropertyDescription;
import com.fasterxml.jackson.annotation.JsonPropertyOrder;

import java.util.HashMap;
import java.util.Map;

import org.apache.commons.lang3.builder.EqualsBuilder;
import org.apache.commons.lang3.builder.HashCodeBuilder;

/**
 * Deploy application request
 *
 * @since 4.0
 */
@JsonInclude(JsonInclude.Include.NON_NULL)
@JsonPropertyOrder({
    "appLocation"
})
public class ApplicationsPUTBody {

  /**
   * Path to the application content
   */
  @JsonProperty("appLocation")
  @JsonPropertyDescription("")
  private String appLocation;
  @JsonIgnore
  private Map<String, Object> additionalProperties = new HashMap<String, Object>();

  /**
   * No args constructor for use in serialization
   */
  public ApplicationsPUTBody() {}

  /**
   * Creates an intance of the request body.
   *
   * @param appLocation the location in file system for the application content to be deployed.
   */
  public ApplicationsPUTBody(String appLocation) {
    super();
    this.appLocation = appLocation;
  }

  @JsonProperty("appLocation")
  public String getAppLocation() {
    return appLocation;
  }

  @JsonProperty("appLocation")
  public void setAppLocation(String appLocation) {
    this.appLocation = appLocation;
  }

  public ApplicationsPUTBody withAppLocation(String appLocation) {
    this.appLocation = appLocation;
    return this;
  }

  @JsonAnyGetter
  public Map<String, Object> getAdditionalProperties() {
    return this.additionalProperties;
  }

  @JsonAnySetter
  public void setAdditionalProperty(String name, Object value) {
    this.additionalProperties.put(name, value);
  }

  public ApplicationsPUTBody withAdditionalProperty(String name, Object value) {
    this.additionalProperties.put(name, value);
    return this;
  }

  @Override
  public boolean equals(Object other) {
    if (other == this) {
      return true;
    }
    if ((other instanceof ApplicationsPUTBody) == false) {
      return false;
    }
    ApplicationsPUTBody rhs = ((ApplicationsPUTBody) other);
    return new EqualsBuilder().append(appLocation, rhs.appLocation).append(additionalProperties, rhs.additionalProperties)
        .isEquals();
  }

  @Override
  public int hashCode() {
    return new HashCodeBuilder().append(appLocation).append(additionalProperties).toHashCode();
  }

  @Override
  public String toString() {
    return reflectionToString(this);
  }

}
