/*
 * Copyright (c) MuleSoft, Inc.  All rights reserved.  http://www.mulesoft.com
 * The software in this package is published under the terms of the CPAL v1.0
 * license, a copy of which has been included with this distribution in the
 * LICENSE.txt file.
 */

package org.mule.tooling.agent.rest.client.tooling;

import org.mule.tooling.agent.rest.client.tooling.applications.Applications;
import org.mule.tooling.agent.rest.client.tooling.applications.applicationId.components.Components;

import javax.ws.rs.client.Client;

/**
 * Tooling Web Resource.
 *
 * @since 4.0
 */
public class Tooling {

  public static final String VERBOSE_QUERY_PARAM = "verbose";

  private String toolingApiUrl;
  private Client client;
  public final Applications applications;
  public final Components components;

  public Tooling(String toolingApiUrl, Client client) {
    this.toolingApiUrl = (toolingApiUrl);
    this.client = client;
    applications = new Applications(getBaseUri(), getClient());
    components = new Components(getBaseUri(), getClient());
  }

  private Client getClient() {
    return this.client;
  }

  private String getBaseUri() {
    return this.toolingApiUrl;
  }

}
