/*
 * Copyright (c) MuleSoft, Inc.  All rights reserved.  http://www.mulesoft.com
 * The software in this package is published under the terms of the CPAL v1.0
 * license, a copy of which has been included with this distribution in the
 * LICENSE.txt file.
 */

package org.mule.tooling.agent.rest.client.exceptions.model;

import java.util.HashMap;
import java.util.Map;

/**
 * Error code for Tooling Agent API.
 *
 * @since 4.0
 */
public enum ErrorCode {
  NO_SUCH_APPLICATION, BUNDLE_NOT_FOUND, CONNECTIVITY_TESTING_OBJECT_NOT_FOUND, UNSUPPORTED_CONNECTIVITY_TESTING_OBJECT, UNKNOWN_ERROR;

  ErrorCode() {}

  private final static Map<String, ErrorCode> mapping;

  static {
    mapping = new HashMap();
    mapping.put("class com.mulesoft.agent.domain.application.NoSuchApplicationException", NO_SUCH_APPLICATION);
    mapping.put("class org.mule.runtime.module.repository.api.BundleNotFoundException", BUNDLE_NOT_FOUND);
    mapping.put("class org.mule.runtime.core.api.exception.ObjectNotFoundException", CONNECTIVITY_TESTING_OBJECT_NOT_FOUND);
    mapping.put("class org.mule.runtime.core.api.connectivity.UnsupportedConnectivityTestingObjectException",
                UNSUPPORTED_CONNECTIVITY_TESTING_OBJECT);
  }

  /**
   * Returns the {@link ErrorCode} mapped for the errorType.
   *
   * @param errorType the {@link String} with the exception fully qualifier name.
   * @return corresponding {@link ErrorCode} or UNKNOWN_ERROR if not mapping was found.
   */
  public static ErrorCode get(String errorType) {
    if (!mapping.containsKey(errorType)) {
      return UNKNOWN_ERROR;
    }
    return mapping.get(errorType);
  }
}
