
/*
 * Copyright (c) MuleSoft, Inc.  All rights reserved.  http://www.mulesoft.com
 * The software in this package is published under the terms of the CPAL v1.0
 * license, a copy of which has been included with this distribution in the
 * LICENSE.txt file.
 */

package org.mule.tooling.agent.rest.client.tooling.applications.applicationId.components.componentId.connection.model;

import static org.apache.commons.lang3.builder.ToStringBuilder.reflectionToString;
import org.mule.runtime.api.message.ErrorType;

import java.util.HashMap;
import java.util.Map;

import org.apache.commons.lang3.builder.EqualsBuilder;
import org.apache.commons.lang3.builder.HashCodeBuilder;

/**
 * Response for a connectivity testing request.
 *
 * @since 4.0
 */
public class ConnectivityTestingResponse {

  /**
   * The status of the connection test. Cannot be {@code null}.
   */
  private Boolean validationStatus;

  /**
   * Message description the connect test failure result
   */
  private String message;

  /**
   * Reason for the connection test to fail
   */
  private String reason;

  /**
   * Exception stack trace that happened during connection test
   */
  private String exception;
  private Map<String, Object> additionalProperties = new HashMap<String, Object>();
  private ErrorType errorType;

  /**
   * No args constructor for use in serialization
   */
  public ConnectivityTestingResponse() {}

  /**
   * Creates an instance of the response entity.
   *
   * @param validationStatus the status of the connection, {@code true} if valid.
   * @param message the error message detailing the failure reason.
   * @param reason the reason for the failure.
   * @param errorType the error errorType {@link ErrorType}.
   * @param exception the exception stack trace that cause the failure.
   */
  public ConnectivityTestingResponse(Boolean validationStatus, String message, ErrorType errorType,
                                     String reason,
                                     String exception) {
    super();
    this.validationStatus = validationStatus;
    this.message = message;
    this.errorType = errorType;
    this.reason = reason;
    this.exception = exception;
  }

  @Override
  public boolean equals(Object other) {
    if (other == this) {
      return true;
    }
    if (!(other instanceof ConnectivityTestingResponse)) {
      return false;
    }
    ConnectivityTestingResponse rhs = ((ConnectivityTestingResponse) other);
    return new EqualsBuilder().append(validationStatus, rhs.validationStatus).append(message, rhs.message)
        .append(errorType, rhs.errorType)
        .append(reason, rhs.reason).append(exception, rhs.exception).append(additionalProperties, rhs.additionalProperties)
        .isEquals();
  }

  @Override
  public int hashCode() {
    return new HashCodeBuilder().append(validationStatus).append(message).append(errorType).append(reason).append(exception)
        .append(additionalProperties).toHashCode();
  }

  @Override
  public String toString() {
    return reflectionToString(this);
  }

  public Boolean getValidationStatus() {
    return validationStatus;
  }

  public String getMessage() {
    return message;
  }

  public String getReason() {
    return reason;
  }

  public String getException() {
    return exception;
  }

  public Map<String, Object> getAdditionalProperties() {
    return additionalProperties;
  }

  public ErrorType getErrorType() {
    return errorType;
  }
}
