
/*
 * Copyright (c) MuleSoft, Inc.  All rights reserved.  http://www.mulesoft.com
 * The software in this package is published under the terms of the CPAL v1.0
 * license, a copy of which has been included with this distribution in the
 * LICENSE.txt file.
 */

package org.mule.tooling.agent.rest.client.tooling.applications.applicationId.model;

import static org.apache.commons.lang3.builder.ToStringBuilder.reflectionToString;

import com.fasterxml.jackson.annotation.JsonAnyGetter;
import com.fasterxml.jackson.annotation.JsonAnySetter;
import com.fasterxml.jackson.annotation.JsonIgnore;
import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonPropertyDescription;
import com.fasterxml.jackson.annotation.JsonPropertyOrder;

import java.util.HashMap;
import java.util.Map;

import org.apache.commons.lang3.builder.EqualsBuilder;
import org.apache.commons.lang3.builder.HashCodeBuilder;

/**
 * Delete application response
 *
 * @since 4.0
 */
@JsonInclude(JsonInclude.Include.NON_NULL)
@JsonPropertyOrder({
    "applicationId"
})
public class ApplicationIdDELETEResponse {

  /**
   * Application identifier
   */
  @JsonProperty("applicationId")
  @JsonPropertyDescription("")
  private String applicationId;
  @JsonIgnore
  private Map<String, Object> additionalProperties = new HashMap<String, Object>();

  /**
   * No args constructor for use in serialization
   */
  public ApplicationIdDELETEResponse() {}

  /**
   * Creates an instance of the response.
   *
   * @param applicationId the application identifier.
   */
  public ApplicationIdDELETEResponse(String applicationId) {
    super();
    this.applicationId = applicationId;
  }

  @JsonProperty("applicationId")
  public String getApplicationId() {
    return applicationId;
  }

  @JsonProperty("applicationId")
  public void setApplicationId(String applicationId) {
    this.applicationId = applicationId;
  }

  public ApplicationIdDELETEResponse withApplicationId(String applicationId) {
    this.applicationId = applicationId;
    return this;
  }

  @JsonAnyGetter
  public Map<String, Object> getAdditionalProperties() {
    return this.additionalProperties;
  }

  @JsonAnySetter
  public void setAdditionalProperty(String name, Object value) {
    this.additionalProperties.put(name, value);
  }

  public ApplicationIdDELETEResponse withAdditionalProperty(String name, Object value) {
    this.additionalProperties.put(name, value);
    return this;
  }

  @Override
  public boolean equals(Object other) {
    if (other == this) {
      return true;
    }
    if ((other instanceof ApplicationIdDELETEResponse) == false) {
      return false;
    }
    ApplicationIdDELETEResponse rhs = ((ApplicationIdDELETEResponse) other);
    return new EqualsBuilder().append(applicationId, rhs.applicationId).append(additionalProperties, rhs.additionalProperties)
        .isEquals();
  }

  @Override
  public int hashCode() {
    return new HashCodeBuilder().append(applicationId).append(additionalProperties).toHashCode();
  }

  @Override
  public String toString() {
    return reflectionToString(this);
  }

}
