
/*
 * Copyright (c) MuleSoft, Inc.  All rights reserved.  http://www.mulesoft.com
 * The software in this package is published under the terms of the CPAL v1.0
 * license, a copy of which has been included with this distribution in the
 * LICENSE.txt file.
 */

package org.mule.tooling.agent.rest.client.tooling.applications.applicationId.flows.flowname;

import org.mule.tooling.agent.rest.client.tooling.applications.applicationId.components.Components;

import javax.ws.rs.client.Client;

/**
 * Flow web resource.
 *
 * @since 4.0
 */
public class FlowName {

  private String baseUrl;
  private Client client;
  public final Components components;

  public FlowName(String baseUrl, Client client, String uriParam) {
    this.baseUrl = (baseUrl + ("/" + uriParam));
    this.client = client;
    components = new Components(getBaseUri(), getClient());
  }

  private Client getClient() {
    return this.client;
  }

  private String getBaseUri() {
    return baseUrl;
  }

}
