/*
 * Decompiled with CFR 0.152.
 */
package org.mule.tooling.agent.rest.client.api;

import java.util.Optional;
import javax.net.ssl.SSLContext;
import javax.ws.rs.client.Client;
import javax.ws.rs.client.ClientBuilder;
import javax.ws.rs.core.Configuration;
import jersey.repackaged.com.google.common.base.Preconditions;
import org.glassfish.jersey.client.ClientConfig;
import org.glassfish.jersey.filter.LoggingFilter;
import org.mule.tooling.agent.rest.client.tooling.Tooling;

public class ToolingServiceAPIClient {
    public final Tooling tooling;

    private ToolingServiceAPIClient(String toolingApiUrl, int defaultConnectTimeout, int defaultReadTimeout, Optional<SSLContext> sslContext) {
        Preconditions.checkNotNull((Object)toolingApiUrl, (Object)"baseUrl cannot be null");
        this.tooling = new Tooling(toolingApiUrl, this.newClient(defaultConnectTimeout, defaultReadTimeout, sslContext));
    }

    private Client newClient(int connectTimeout, int readTimeout, Optional<SSLContext> sslContextOptional) {
        ClientConfig configuration = new ClientConfig();
        configuration.property("jersey.config.client.connectTimeout", (Object)connectTimeout);
        configuration.property("jersey.config.client.readTimeout", (Object)readTimeout);
        ClientBuilder builder = ClientBuilder.newBuilder();
        builder.register((Object)new LoggingFilter());
        builder.withConfig((Configuration)configuration);
        sslContextOptional.ifPresent(sslContext -> builder.sslContext(sslContext));
        return builder.build();
    }

    public static ToolingServiceAPIClient create(String baseUrl, int defaultConnectTimeout, int defaultReadTimeout, Optional<SSLContext> sslContext) {
        return new ToolingServiceAPIClient(baseUrl, defaultConnectTimeout, defaultReadTimeout, sslContext);
    }
}

