/*
 * Copyright (c) MuleSoft, Inc.  All rights reserved.  http://www.mulesoft.com
 * The software in this package is published under the terms of the CPAL v1.0
 * license, a copy of which has been included with this distribution in the
 * LICENSE.txt file.
 */
package org.mule.tooling.agent.rest.client;

import static org.hamcrest.MatcherAssert.assertThat;
import static org.hamcrest.core.Is.is;
import static org.hamcrest.core.IsCollectionContaining.hasItems;
import static org.mule.tck.junit4.matcher.ValueMatcher.valueWithId;
import org.mule.runtime.api.component.location.Location;
import org.mule.runtime.api.value.ValueResult;
import org.mule.tooling.client.test.RuntimeType;
import io.qameta.allure.Description;
import io.qameta.allure.Feature;
import io.qameta.allure.Story;
import org.junit.Test;

import java.io.File;
import java.io.FileNotFoundException;
import java.net.MalformedURLException;
import java.net.URISyntaxException;

@Feature("Remote Runtime Tooling Service")
@Story("Value Provider")
public class ValueProvidersTestCase extends AbstractRestAgentToolingServiceTestCase {

  public ValueProvidersTestCase(RuntimeType runtimeType) {
    super(runtimeType);
  }

  @Test
  @Description("Resolves the Values through the ValueProviderService for the ContentTransferEncoding parameter")
  public void getValueForEmailContentTransferEncoding() throws URISyntaxException, MalformedURLException, FileNotFoundException {
    File targetTestClassesFolder = new File(this.getClass().getProtectionDomain().getCodeSource().getLocation().toURI());
    File emailAppLocation = new File(targetTestClassesFolder, "applications/value-providers");

    String applicationId = restAgentToolingService.deployApplication(emailAppLocation);
    String sendEmail = Location.builder().globalName("sendEmail").addProcessorsPart().addIndexPart(0).build().toString();

    ValueResult values = restAgentToolingService.getValues(applicationId, sendEmail, "contentTransferEncoding");

    assertThat(values.isSuccess(), is(true));
    assertThat(values.getValues(), is(hasItems(valueWithId("7BIT"), valueWithId("8BIT"), valueWithId("Base64"),
                                               valueWithId("Quoted-Printable"), valueWithId("Binary"))));
  }
}
