/*
 * Copyright (c) MuleSoft, Inc.  All rights reserved.  http://www.mulesoft.com
 * The software in this package is published under the terms of the CPAL v1.0
 * license, a copy of which has been included with this distribution in the
 * LICENSE.txt file.
 */
package org.mule.tooling.agent.rest.client.tooling.domains.domainId.dataWeave.execute;

import static javax.ws.rs.core.MediaType.APPLICATION_JSON;
import static javax.ws.rs.core.MediaType.APPLICATION_JSON_TYPE;
import static javax.ws.rs.core.Response.Status.Family.SUCCESSFUL;
import static org.glassfish.jersey.client.ClientProperties.READ_TIMEOUT;
import static org.mule.tooling.agent.rest.client.exceptions.ToolingServiceAPIException.newToolingServiceAPIException;
import static org.mule.tooling.agent.rest.client.tooling.Tooling.VERBOSE_QUERY_PARAM;
import org.mule.tooling.agent.rest.client.exceptions.ToolingServiceAPIException;

import com.mulesoft.agent.domain.tooling.dataweave.model.PreviewRequest;
import com.mulesoft.agent.domain.tooling.dataweave.model.PreviewResponse;

import javax.ws.rs.client.Client;
import javax.ws.rs.client.Entity;
import javax.ws.rs.client.WebTarget;
import javax.ws.rs.core.Response;

public class Execute {

  private String baseUrl;
  private Client client;

  public Execute(String baseUrl, Client client) {
    this.baseUrl = (baseUrl + "/execute");
    this.client = client;
  }

  private Client getClient() {
    return this.client;
  }

  private String getBaseUri() {
    return baseUrl;
  }

  /**
   * Run dataweave script in the context of an application described by applicationId
   * @param request parameters for running dataweave script
   * @param readTimeout           read timeout in milliseconds
   * @param verboseErrorsEnabled  flag that defines if it has to be verbose the response in case of errors/failures.
   * @return a wrapper that describes execution result and provide error details if failed
   */
  public PreviewResponse post(PreviewRequest request, boolean verboseErrorsEnabled, int readTimeout)
      throws ToolingServiceAPIException {
    WebTarget target = this.getClient().target(getBaseUri());
    target = target.queryParam(VERBOSE_QUERY_PARAM, verboseErrorsEnabled);
    final javax.ws.rs.client.Invocation.Builder invocationBuilder = target.request(APPLICATION_JSON_TYPE);
    if (readTimeout > 0) {
      invocationBuilder.property(READ_TIMEOUT, readTimeout);
    }
    Entity<PreviewRequest> post = Entity.entity(request, APPLICATION_JSON);
    Response response = invocationBuilder.post(post);
    if (response.getStatusInfo().getFamily() != SUCCESSFUL) {
      throw newToolingServiceAPIException(response);
    }
    return response.readEntity(PreviewResponse.class);
  }

}
