
/*
 * Copyright (c) MuleSoft, Inc.  All rights reserved.  http://www.mulesoft.com
 * The software in this package is published under the terms of the CPAL v1.0
 * license, a copy of which has been included with this distribution in the
 * LICENSE.txt file.
 */

package org.mule.tooling.agent.rest.client.tooling.domains.domainId;

import static javax.ws.rs.core.MediaType.APPLICATION_JSON_TYPE;
import static javax.ws.rs.core.Response.Status.Family.SUCCESSFUL;
import static org.glassfish.jersey.client.ClientProperties.READ_TIMEOUT;
import static org.mule.tooling.agent.rest.client.exceptions.ToolingServiceAPIException.newToolingServiceAPIException;
import static org.mule.tooling.agent.rest.client.tooling.Tooling.VERBOSE_QUERY_PARAM;
import org.mule.tooling.agent.rest.client.exceptions.ToolingServiceAPIException;
import org.mule.tooling.agent.rest.client.tooling.applications.applicationId.components.Components;
import org.mule.tooling.agent.rest.client.tooling.applications.applicationId.dataWeave.DataWeave;
import org.mule.tooling.agent.rest.client.tooling.domains.domainId.model.DomainIdDELETEResponse;

import javax.ws.rs.client.Client;
import javax.ws.rs.client.WebTarget;
import javax.ws.rs.core.Response;

/**
 * Domain web resource.
 *
 * @since 4.0
 */
public class DomainId {

  private String baseUrl;
  private Client client;
  public final Components components;
  public final DataWeave dataweave;

  public DomainId(String baseUrl, Client client, String uriParam) {
    this.baseUrl = (baseUrl + ("/" + uriParam));
    this.client = client;
    dataweave = new DataWeave(getBaseUri(), getClient());
    components = new Components(getBaseUri(), getClient());
  }

  private Client getClient() {
    return this.client;
  }

  private String getBaseUri() {
    return baseUrl;
  }

  /**
   * DELETE operation, disposes this tooling domain.
   *
   * @param verboseErrorsEnabled  flag that defines if it has to be verbose the response in case of errors/failures.
   * @param readTimeout           read timeout in milliseconds
   * @return {@link DomainIdDELETEResponse} with disposed domain identifier.
   * @throws ToolingServiceAPIException if there was an error.
   * @param verboseErrorsEnabled
   */
  public DomainIdDELETEResponse delete(boolean verboseErrorsEnabled, int readTimeout) throws ToolingServiceAPIException {
    WebTarget target = this.getClient().target(getBaseUri());
    target = target.queryParam(VERBOSE_QUERY_PARAM, verboseErrorsEnabled);
    final javax.ws.rs.client.Invocation.Builder invocationBuilder = target.request(APPLICATION_JSON_TYPE);
    if (readTimeout > 0) {
      invocationBuilder.property(READ_TIMEOUT, readTimeout);
    }
    Response response = invocationBuilder.delete();
    if (response.getStatusInfo().getFamily() != SUCCESSFUL) {
      throw newToolingServiceAPIException(response);
    }
    return response.readEntity(DomainIdDELETEResponse.class);
  }

}
