/*
 * Copyright (c) MuleSoft, Inc.  All rights reserved.  http://www.mulesoft.com
 * The software in this package is published under the terms of the CPAL v1.0
 * license, a copy of which has been included with this distribution in the
 * LICENSE.txt file.
 */

package org.mule.tooling.agent.rest.client;

import static org.hamcrest.Matchers.is;
import static org.hamcrest.Matchers.notNullValue;
import static org.junit.Assert.assertThat;
import static org.mule.tooling.client.test.utils.ZipUtils.compress;
import org.mule.tooling.client.test.RuntimeType;

import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.net.URISyntaxException;

import io.qameta.allure.Description;
import io.qameta.allure.Feature;
import io.qameta.allure.Story;
import org.junit.Test;

@Feature("Remote Runtime Tooling Service - Domains")
@Story("DeployToolingArtifact")
public class DeployDomainTestCase extends AbstractDeploymentTestCase {

  public DeployDomainTestCase(RuntimeType runtimeType) {
    super(runtimeType);
  }

  @Test
  @Description("Checks the deployment of a Tooling Artifact for a Domain from Mule Agent using the RuntimeToolingService")
  public void deployDomain() throws URISyntaxException {
    File targetTestClassesFolder = new File(this.getClass().getProtectionDomain().getCodeSource().getLocation().toURI());
    File domainLocation = new File(targetTestClassesFolder, "domains/email-domain-exploded");

    String domainId = restAgentToolingService.deployDomain(domainLocation);

    assertThat(domainId, is(notNullValue()));
  }

  @Test
  @Description("Checks the deployment of a Tooling Artifact for a Domain from Mule Agent using the RuntimeToolingService")
  public void deployDomainInputStream() throws URISyntaxException, IOException {
    File targetTestClassesFolder = new File(this.getClass().getProtectionDomain().getCodeSource().getLocation().toURI());
    File domainLocation = new File(targetTestClassesFolder, "domains/email-domain-exploded");

    File targetFile = temporaryFolder.newFile();
    compress(targetFile, domainLocation);

    String domainId = restAgentToolingService.deployDomain(new FileInputStream(targetFile));

    assertThat(domainId, is(notNullValue()));
  }

  @Test
  @Description("Checks the deployment of a Tooling Artifact for a Domain can be later disposed from Mule Agent using the RuntimeToolingService")
  public void disposeDomain() throws URISyntaxException {
    File targetTestClassesFolder = new File(this.getClass().getProtectionDomain().getCodeSource().getLocation().toURI());
    File domainLocation = new File(targetTestClassesFolder, "domains/email-domain-exploded");

    String domainId = restAgentToolingService.deployDomain(domainLocation);

    assertThat(domainId, is(notNullValue()));

    restAgentToolingService.disposeDomain(domainId);
  }

}
