
/*
 * Copyright (c) MuleSoft, Inc.  All rights reserved.  http://www.mulesoft.com
 * The software in this package is published under the terms of the CPAL v1.0
 * license, a copy of which has been included with this distribution in the
 * LICENSE.txt file.
 */

package org.mule.tooling.agent.rest.client.tooling.applications.applicationName;

import org.mule.tooling.agent.rest.client.tooling.applications.applicationName.messageHistory.MessageHistory;

import javax.ws.rs.client.Client;

/**
 * Application web resource.
 *
 * @since 4.0
 */
public class ApplicationName {

  private String baseUrl;
  private Client client;
  public final MessageHistory messageHistory;

  public ApplicationName(String baseUrl, Client client, String uriParam) {
    this.baseUrl = baseUrl + "/" + uriParam;
    this.client = client;
    messageHistory = new MessageHistory(getBaseUri(), getClient());
  }

  private Client getClient() {
    return this.client;
  }

  private String getBaseUri() {
    return baseUrl;
  }

}
