/*
 * Decompiled with CFR 0.152.
 */
package org.mule.tooling.agent.rest.client;

import com.mulesoft.agent.domain.tooling.BundleDescriptor;
import com.mulesoft.agent.domain.tooling.dataweave.model.PreviewRequest;
import com.mulesoft.agent.domain.tooling.dataweave.model.PreviewResponse;
import com.mulesoft.agent.external.handlers.tooling.TestConnectionRequest;
import java.io.File;
import java.io.FileInputStream;
import java.io.InputStream;
import java.net.ConnectException;
import java.net.SocketTimeoutException;
import java.net.URL;
import java.security.KeyStore;
import java.security.SecureRandom;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.Supplier;
import javax.net.ssl.HttpsURLConnection;
import javax.net.ssl.KeyManagerFactory;
import javax.net.ssl.SSLContext;
import javax.net.ssl.TrustManagerFactory;
import javax.ws.rs.ProcessingException;
import javax.ws.rs.client.Client;
import javax.ws.rs.client.ClientBuilder;
import org.apache.commons.lang3.ClassUtils;
import org.mule.runtime.api.meta.model.ComponentModel;
import org.mule.runtime.api.meta.model.operation.OperationModel;
import org.mule.runtime.api.meta.model.source.SourceModel;
import org.mule.runtime.api.metadata.MetadataKeysContainer;
import org.mule.runtime.api.metadata.descriptor.ComponentMetadataDescriptor;
import org.mule.runtime.api.metadata.resolving.MetadataResult;
import org.mule.runtime.api.value.ValueResult;
import org.mule.runtime.app.declaration.api.ArtifactDeclaration;
import org.mule.tooling.agent.RuntimeToolingService;
import org.mule.tooling.agent.rest.client.ConnectionValidationResultFactory;
import org.mule.tooling.agent.rest.client.api.ToolingServiceAPIClient;
import org.mule.tooling.agent.rest.client.exceptions.ToolingServiceAPIException;
import org.mule.tooling.agent.rest.client.exceptions.model.ErrorCode;
import org.mule.tooling.agent.rest.client.service.ServiceFunction;
import org.mule.tooling.agent.rest.client.tooling.applications.applicationId.components.componentId.connection.model.ConnectivityTestingResponse;
import org.mule.tooling.agent.rest.client.tooling.applications.applicationName.messageHistory.AgentTrackingNotificationResponse;
import org.mule.tooling.agent.rest.client.tooling.applications.model.ApplicationsPUTBody;
import org.mule.tooling.agent.rest.client.tooling.domains.model.DomainsPUTBody;
import org.mule.tooling.client.api.configuration.ssl.SslConfiguration;
import org.mule.tooling.client.api.connectivity.BundleNotFoundException;
import org.mule.tooling.client.api.connectivity.ConnectionValidationResult;
import org.mule.tooling.client.api.connectivity.ConnectivityTestingObjectNotFoundException;
import org.mule.tooling.client.api.connectivity.UnsupportedConnectivityTestingObjectException;
import org.mule.tooling.client.api.exception.DeploymentException;
import org.mule.tooling.client.api.exception.NoSuchApplicationException;
import org.mule.tooling.client.api.exception.ServiceUnavailableException;
import org.mule.tooling.client.api.exception.TimeoutException;
import org.mule.tooling.client.api.exception.ToolingException;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class RestAgentToolingService
implements RuntimeToolingService {
    private final Logger logger = LoggerFactory.getLogger(this.getClass());
    private ToolingServiceAPIClient client;
    private URL url;
    private int defaultReadTimeout;
    private static boolean VERBOSE_ERROR_ENABLED = true;
    private Optional<SSLContext> sslContext;

    @Override
    public void setToolingApiUrl(URL url, long defaultConnectTimeout, long defaultReadTimeout, Optional<SslConfiguration> sslConfiguration) {
        Objects.requireNonNull(url, "url cannot be null");
        if (this.logger.isDebugEnabled()) {
            this.logger.debug("Configuring using tooling API URL:{}, defaultConnectTimeout:{}ms, defaultReadTimeout:{}ms", new Object[]{url, defaultConnectTimeout, defaultReadTimeout});
        }
        this.sslContext = sslConfiguration.map(configuration -> {
            try {
                FileInputStream keyStoreFile = new FileInputStream(configuration.getKeyStoreConfig().getKeyStoreFile());
                FileInputStream trustStoreFile = new FileInputStream(configuration.getTrustStoreConfig().getTrustStoreFile());
                KeyStore trustStore = KeyStore.getInstance("JKS");
                trustStore.load(trustStoreFile, configuration.getKeyStoreConfig().getKeyStorePassword().toCharArray());
                KeyStore keyStore = KeyStore.getInstance("JKS");
                keyStore.load(keyStoreFile, configuration.getTrustStoreConfig().getTrustStorePassword().toCharArray());
                SSLContext ctx = SSLContext.getInstance("TLSv1.2");
                KeyManagerFactory sunX509 = KeyManagerFactory.getInstance("SunX509");
                sunX509.init(keyStore, configuration.getKeyStoreConfig().getKeyStorePassword().toCharArray());
                TrustManagerFactory trustManagerFactory = TrustManagerFactory.getInstance("SunX509", "SunJSSE");
                trustManagerFactory.init(trustStore);
                ctx.init(sunX509.getKeyManagers(), trustManagerFactory.getTrustManagers(), new SecureRandom());
                HttpsURLConnection.setDefaultHostnameVerifier((s, sslSession) -> true);
                return Optional.of(ctx);
            }
            catch (Exception e) {
                throw new IllegalArgumentException("Error while configuring mutual SSL to connect to the Mule Agent REST API.", e);
            }
        }).orElse(Optional.empty());
        this.defaultReadTimeout = Long.valueOf(defaultReadTimeout).intValue();
        this.client = ToolingServiceAPIClient.create(url.toString(), Long.valueOf(defaultConnectTimeout).intValue(), this.defaultReadTimeout, this.sslContext);
        this.url = url;
    }

    @Override
    public boolean isOperational() {
        ClientBuilder builder = ClientBuilder.newBuilder();
        this.sslContext.ifPresent(sslContext -> builder.sslContext(sslContext));
        Client client = builder.build();
        try {
            client.target(this.url.toString()).request().buildGet().invoke();
            return true;
        }
        catch (ProcessingException e) {
            if (e.getCause() instanceof ConnectException) {
                return false;
            }
            throw new ToolingException("Error while checking if Mule Agent REST service is available", (Throwable)e);
        }
    }

    @Override
    public String deployApplication(File appLocation, String domainName) {
        if (this.logger.isDebugEnabled()) {
            this.logger.debug("PUT:tooling/applications appLocation:[{}], domain:{}", (Object)appLocation, (Object)(domainName != null ? domainName : ""));
        }
        try {
            return ServiceFunction.serviceCallWrapper(() -> this.client.tooling.applications.put(new ApplicationsPUTBody(appLocation.getAbsolutePath(), domainName), VERBOSE_ERROR_ENABLED, this.defaultReadTimeout).getApplicationId(), this.createDescription("deploy(application)"));
        }
        catch (Exception e) {
            if (e.getCause() instanceof ConnectException) {
                throw new ServiceUnavailableException("Mule Agent REST service is not available", e);
            }
            if (e.getCause() instanceof SocketTimeoutException) {
                throw new TimeoutException("Mule Agent REST service timed out", (Throwable)e);
            }
            throw new DeploymentException("Couldn't deploy the application", e);
        }
    }

    private String createDescription(String method) {
        return RuntimeToolingService.class.getSimpleName() + "#" + method;
    }

    @Override
    public String deployDomain(File domainLocation) {
        if (this.logger.isDebugEnabled()) {
            this.logger.debug("PUT:tooling/domains domainLocation:[{}]", (Object)domainLocation);
        }
        try {
            return ServiceFunction.serviceCallWrapper(() -> this.client.tooling.domains.put(new DomainsPUTBody(domainLocation.getAbsolutePath()), VERBOSE_ERROR_ENABLED, this.defaultReadTimeout).getDomainId(), this.createDescription("deploy(domain)"));
        }
        catch (Exception e) {
            if (e.getCause() instanceof ConnectException) {
                throw new ServiceUnavailableException("Mule Agent REST service is not available", e);
            }
            if (e.getCause() instanceof SocketTimeoutException) {
                throw new TimeoutException("Mule Agent REST service timed out", (Throwable)e);
            }
            throw new DeploymentException("Couldn't deploy the domain", e);
        }
    }

    @Override
    public String deployDomain(InputStream inputStream) throws DeploymentException, ServiceUnavailableException {
        this.logger.debug("PUT:tooling/domains inputStream");
        try {
            return ServiceFunction.serviceCallWrapper(() -> this.client.tooling.domains.put(inputStream, VERBOSE_ERROR_ENABLED, this.defaultReadTimeout).getDomainId(), this.createDescription("deploy(domain)"));
        }
        catch (Exception e) {
            if (e.getCause() instanceof ConnectException) {
                throw new ServiceUnavailableException("Mule Agent REST service is not available", e);
            }
            if (e.getCause() instanceof SocketTimeoutException) {
                throw new TimeoutException("Mule Agent REST service timed out", (Throwable)e);
            }
            throw new DeploymentException("Couldn't deploy the domain", e);
        }
    }

    @Override
    public String deployApplication(InputStream inputStream) throws DeploymentException, ServiceUnavailableException {
        this.logger.debug("PUT:tooling/applications inputStream");
        try {
            return ServiceFunction.serviceCallWrapper(() -> this.client.tooling.applications.put(inputStream, VERBOSE_ERROR_ENABLED, this.defaultReadTimeout).getApplicationId(), this.createDescription("deploy(application)"));
        }
        catch (Exception e) {
            if (e.getCause() instanceof ConnectException) {
                throw new ServiceUnavailableException("Mule Agent REST service is not available", e);
            }
            if (e.getCause() instanceof SocketTimeoutException) {
                throw new TimeoutException("Mule Agent REST service timed out", (Throwable)e);
            }
            throw new DeploymentException("Couldn't deploy the application", e);
        }
    }

    @Override
    public String deployApplication(InputStream inputStream, String domainName) throws DeploymentException, ServiceUnavailableException {
        this.logger.debug("PUT:tooling/applications inputStream");
        try {
            return ServiceFunction.serviceCallWrapper(() -> this.client.tooling.applications.put(inputStream, domainName, VERBOSE_ERROR_ENABLED, this.defaultReadTimeout).getApplicationId(), this.createDescription("deploy(application)"));
        }
        catch (Exception e) {
            if (e.getCause() instanceof ConnectException) {
                throw new ServiceUnavailableException("Mule Agent REST service is not available", e);
            }
            if (e.getCause() instanceof SocketTimeoutException) {
                throw new TimeoutException("Mule Agent REST service timed out", (Throwable)e);
            }
            throw new DeploymentException("Couldn't deploy the application", e);
        }
    }

    @Override
    public void disposeApplication(String applicationId) throws ServiceUnavailableException {
        if (this.logger.isDebugEnabled()) {
            this.logger.debug("DELETE:tooling/applications/{}", (Object)applicationId);
        }
        try {
            ServiceFunction.serviceCallWrapper(() -> this.client.tooling.applications.applicationId(applicationId).delete(VERBOSE_ERROR_ENABLED, this.defaultReadTimeout), this.createDescription("dispose(application)"));
        }
        catch (Exception e) {
            if (e.getCause() instanceof ConnectException) {
                throw new ServiceUnavailableException("Mule Agent REST service is not available", e);
            }
            if (e.getCause() instanceof SocketTimeoutException) {
                throw new TimeoutException("Mule Agent REST service timed out", (Throwable)e);
            }
            throw new ToolingException(String.format("Couldn't dispose application, for applicationId: %s", applicationId), (Throwable)e);
        }
    }

    @Override
    public void disposeDomain(String domainId) throws ServiceUnavailableException {
        if (this.logger.isDebugEnabled()) {
            this.logger.debug("DELETE:tooling/domains/{}", (Object)domainId);
        }
        try {
            ServiceFunction.serviceCallWrapper(() -> this.client.tooling.domains.domainId(domainId).delete(VERBOSE_ERROR_ENABLED, this.defaultReadTimeout), this.createDescription("dispose(domain)"));
        }
        catch (Exception e) {
            if (e.getCause() instanceof ConnectException) {
                throw new ServiceUnavailableException("Mule Agent REST service is not available", e);
            }
            if (e.getCause() instanceof SocketTimeoutException) {
                throw new TimeoutException("Mule Agent REST service timed out", (Throwable)e);
            }
            throw new ToolingException(String.format("Couldn't dispose domain, for domainId: %s", domainId), (Throwable)e);
        }
    }

    @Override
    public ConnectionValidationResult testConnectionApplication(String applicationId, String componentId, long readTimeout) throws NoSuchApplicationException, UnsupportedConnectivityTestingObjectException, ConnectivityTestingObjectNotFoundException, ServiceUnavailableException {
        if (this.logger.isDebugEnabled()) {
            this.logger.debug("GET:tooling/applications/{}/components/{}/connection", (Object)applicationId, (Object)componentId);
        }
        try {
            ConnectivityTestingResponse response = ServiceFunction.serviceCallWrapper(() -> this.client.tooling.applications.applicationId((String)applicationId).components.componentId((String)componentId).connection.get(VERBOSE_ERROR_ENABLED, Long.valueOf(readTimeout).intValue()), this.createDescription("testConnection(application)"));
            return response.getValidationStatus() != false ? ConnectionValidationResultFactory.success() : ConnectionValidationResultFactory.failure(response.getMessage(), response.getErrorType(), response.getException());
        }
        catch (ToolingServiceAPIException e) {
            return this.handleConnectivityTestingError(e);
        }
        catch (Exception e) {
            if (e.getCause() instanceof ConnectException) {
                throw new ServiceUnavailableException("Mule Agent REST service is not available", e);
            }
            if (e.getCause() instanceof SocketTimeoutException) {
                throw new TimeoutException("Mule Agent REST service timed out", (Throwable)e);
            }
            throw new ToolingException("Error while doing connectivity testing on application", (Throwable)e);
        }
    }

    @Override
    public ConnectionValidationResult testConnectionDomain(String domainId, String componentId, long readTimeout) throws NoSuchApplicationException, UnsupportedConnectivityTestingObjectException, ConnectivityTestingObjectNotFoundException, ServiceUnavailableException {
        if (this.logger.isDebugEnabled()) {
            this.logger.debug("GET:tooling/domains/{}/components/{}/connection", (Object)domainId, (Object)componentId);
        }
        try {
            ConnectivityTestingResponse response = ServiceFunction.serviceCallWrapper(() -> this.client.tooling.domains.domainId((String)domainId).components.componentId((String)componentId).connection.get(VERBOSE_ERROR_ENABLED, Long.valueOf(readTimeout).intValue()), this.createDescription("testConnection(domain)"));
            return response.getValidationStatus() != false ? ConnectionValidationResultFactory.success() : ConnectionValidationResultFactory.failure(response.getMessage(), response.getErrorType(), response.getException());
        }
        catch (ToolingServiceAPIException e) {
            return this.handleConnectivityTestingError(e);
        }
        catch (Exception e) {
            if (e.getCause() instanceof ConnectException) {
                throw new ServiceUnavailableException("Mule Agent REST service is not available", e);
            }
            if (e.getCause() instanceof SocketTimeoutException) {
                throw new TimeoutException("Mule Agent REST service timed out", (Throwable)e);
            }
            throw new ToolingException("Error while doing connectivity testing on domain", (Throwable)e);
        }
    }

    @Override
    public ConnectionValidationResult testConnection(List<BundleDescriptor> dependencies, ArtifactDeclaration artifactDeclaration, String componentId, long readTimeout) throws UnsupportedConnectivityTestingObjectException, ConnectivityTestingObjectNotFoundException, ServiceUnavailableException {
        if (this.logger.isDebugEnabled()) {
            this.logger.debug("PUT:tooling/components/{}/connection", (Object)componentId);
        }
        try {
            ConnectivityTestingResponse response = ServiceFunction.serviceCallWrapper(() -> this.client.tooling.components.componentId((String)componentId).connection.put(this.createRequest(dependencies, artifactDeclaration), VERBOSE_ERROR_ENABLED, Long.valueOf(readTimeout).intValue()), this.createDescription("testConnection(temporaryArtifact)"));
            return response.getValidationStatus() != false ? ConnectionValidationResultFactory.success() : ConnectionValidationResultFactory.failure(response.getMessage(), response.getErrorType(), response.getException());
        }
        catch (ToolingServiceAPIException e) {
            return this.handleConnectivityTestingError(e);
        }
        catch (Exception e) {
            if (e.getCause() instanceof ConnectException) {
                throw new ServiceUnavailableException("Mule Agent REST service is not available", e);
            }
            if (e.getCause() instanceof SocketTimeoutException) {
                throw new TimeoutException("Mule Agent REST service timed out", (Throwable)e);
            }
            throw new ToolingException("Error while doing connectivity testing for a temporary application", (Throwable)e);
        }
    }

    @Override
    public PreviewResponse runDataWeaveApplication(String applicationId, PreviewRequest request) {
        if (this.logger.isDebugEnabled()) {
            this.logger.debug("POST:tooling/applications/{}/dataweave/execute", (Object)applicationId);
        }
        try {
            PreviewResponse response = ServiceFunction.serviceCallWrapper(() -> this.client.tooling.applications.applicationId((String)applicationId).dataweave.execute.post(request, VERBOSE_ERROR_ENABLED, this.defaultReadTimeout), this.createDescription("runDataWeave(application)"));
            return response;
        }
        catch (Exception e) {
            if (e.getCause() instanceof ConnectException) {
                throw new ServiceUnavailableException("Mule Agent REST service is not available", e);
            }
            if (e.getCause() instanceof SocketTimeoutException) {
                throw new TimeoutException("Mule Agent REST service timed out", (Throwable)e);
            }
            throw new ToolingException("Error while executing dataweave script for a temporary application", (Throwable)e);
        }
    }

    @Override
    public PreviewResponse runDataWeaveDomain(String domainId, PreviewRequest request) {
        if (this.logger.isDebugEnabled()) {
            this.logger.debug("POST:tooling/domains/{}/dataweave/execute", (Object)domainId);
        }
        try {
            PreviewResponse response = ServiceFunction.serviceCallWrapper(() -> this.client.tooling.domains.domainId((String)domainId).dataweave.execute.post(request, VERBOSE_ERROR_ENABLED, this.defaultReadTimeout), this.createDescription("runDataWeave(domain)"));
            return response;
        }
        catch (Exception e) {
            if (e.getCause() instanceof ConnectException) {
                throw new ServiceUnavailableException("Mule Agent REST service is not available", e);
            }
            if (e.getCause() instanceof SocketTimeoutException) {
                throw new TimeoutException("Mule Agent REST service timed out", (Throwable)e);
            }
            throw new ToolingException("Error while executing dataweave script for a temporary domain", (Throwable)e);
        }
    }

    private TestConnectionRequest createRequest(List<BundleDescriptor> dependencies, ArtifactDeclaration artifactDeclaration) {
        TestConnectionRequest request = new TestConnectionRequest();
        request.setArtifactDeclaration(artifactDeclaration);
        request.setDependencies(dependencies);
        return request;
    }

    private ConnectionValidationResult handleConnectivityTestingError(ToolingServiceAPIException e) {
        ErrorCode errorCode = e.getErrorCode();
        if (errorCode == null) {
            throw new ToolingException("Internal server error while doing connectivity testing", (Throwable)e);
        }
        if (errorCode == ErrorCode.NO_SUCH_APPLICATION) {
            throw new NoSuchApplicationException("Application resource not found", (Exception)e);
        }
        if (errorCode == ErrorCode.BUNDLE_NOT_FOUND) {
            throw new BundleNotFoundException("Extension bundle not found", (Exception)e);
        }
        if (errorCode == ErrorCode.CONNECTIVITY_TESTING_OBJECT_NOT_FOUND) {
            throw new ConnectivityTestingObjectNotFoundException("Component resource not found", (Exception)e);
        }
        if (errorCode == ErrorCode.UNSUPPORTED_CONNECTIVITY_TESTING_OBJECT) {
            throw new UnsupportedConnectivityTestingObjectException("Component doesn't support connectivity testing", (Exception)e);
        }
        if (errorCode == ErrorCode.UNKNOWN_ERROR) {
            throw new ToolingException("Unknown error while doing connectivity testing", (Throwable)e);
        }
        throw new ToolingException("Internal server error while doing connectivity testing for application", (Throwable)e);
    }

    @Override
    public MetadataResult<MetadataKeysContainer> getMetadataKeysApplication(String applicationId, String componentLocation, long readTimeout) throws ServiceUnavailableException {
        if (this.logger.isDebugEnabled()) {
            this.logger.debug("GET:tooling/applications/{}/components/{}/keys", (Object)applicationId, (Object)componentLocation);
        }
        try {
            return ServiceFunction.serviceCallWrapper(() -> this.client.tooling.applications.applicationId((String)applicationId).components.componentId((String)componentLocation).keys.get(VERBOSE_ERROR_ENABLED, Long.valueOf(readTimeout).intValue()), this.createDescription("getMetadataKeys(application)"));
        }
        catch (Exception e) {
            if (e.getCause() instanceof ConnectException) {
                throw new ServiceUnavailableException("Mule Agent REST service is not available", e);
            }
            if (e.getCause() instanceof SocketTimeoutException) {
                throw new TimeoutException("Mule Agent REST service timed out", (Throwable)e);
            }
            throw new ToolingException("Error while getting Metadata keys", (Throwable)e);
        }
    }

    @Override
    public MetadataResult<MetadataKeysContainer> getMetadataKeysDomain(String domainId, String componentLocation, long readTimeout) throws ServiceUnavailableException {
        if (this.logger.isDebugEnabled()) {
            this.logger.debug("GET:tooling/domains/{}/components/{}/keys", (Object)domainId, (Object)componentLocation);
        }
        try {
            return ServiceFunction.serviceCallWrapper(() -> this.client.tooling.domains.domainId((String)domainId).components.componentId((String)componentLocation).keys.get(VERBOSE_ERROR_ENABLED, Long.valueOf(readTimeout).intValue()), this.createDescription("getMetadataKeys(domain)"));
        }
        catch (Exception e) {
            if (e.getCause() instanceof ConnectException) {
                throw new ServiceUnavailableException("Mule Agent REST service is not available", e);
            }
            if (e.getCause() instanceof SocketTimeoutException) {
                throw new TimeoutException("Mule Agent REST service timed out", (Throwable)e);
            }
            throw new ToolingException("Error while getting Metadata keys", (Throwable)e);
        }
    }

    @Override
    public MetadataResult<ComponentMetadataDescriptor<OperationModel>> getOperationMetadata(String applicationId, String componentLocation, long readTimeout) throws ServiceUnavailableException {
        return this.getMetadata(applicationId, componentLocation, readTimeout);
    }

    @Override
    public MetadataResult<ComponentMetadataDescriptor<SourceModel>> getSourceMetadata(String applicationId, String componentLocation, long readTimeout) throws ServiceUnavailableException {
        return this.getMetadata(applicationId, componentLocation, readTimeout);
    }

    private <T extends ComponentModel> MetadataResult<ComponentMetadataDescriptor<T>> getMetadata(String applicationId, String componentLocation, long readTimeout) {
        if (this.logger.isDebugEnabled()) {
            this.logger.debug("GET:tooling/applications/{}/components/{}/metadata", (Object)applicationId, (Object)componentLocation);
        }
        try {
            return ServiceFunction.serviceCallWrapper(() -> this.client.tooling.applications.applicationId((String)applicationId).components.componentId((String)componentLocation).metadata.get(VERBOSE_ERROR_ENABLED, Long.valueOf(readTimeout).intValue()), this.createDescription("getMetadata"));
        }
        catch (Exception e) {
            if (e.getCause() instanceof ConnectException) {
                throw new ServiceUnavailableException("Mule Agent REST service is not available", e);
            }
            if (e.getCause() instanceof SocketTimeoutException) {
                throw new TimeoutException("Mule Agent REST service timed out", (Throwable)e);
            }
            throw new ToolingException("Error while getting Metadata", (Throwable)e);
        }
    }

    @Override
    public void disposeApplicationMetadataCache(String applicationId, String hashKey) {
        if (this.logger.isDebugEnabled()) {
            this.logger.debug("DELETE:tooling/applications/{}/cache/{}", (Object)applicationId, (Object)hashKey);
        }
        this.doDisposeMetadataCache(() -> {
            this.client.tooling.applications.applicationId((String)applicationId).cache.hashKey(hashKey).delete(VERBOSE_ERROR_ENABLED);
            return null;
        }, this.createDescription("disposeApplicationMetadataCache"), "Error while disposing Metadata");
    }

    private <OutputType> OutputType doDisposeMetadataCache(Supplier<OutputType> function, String serviceMethod, String errorMessage) {
        try {
            return ServiceFunction.serviceCallWrapper(function, this.createDescription(serviceMethod));
        }
        catch (Exception e) {
            if (e.getCause() instanceof ConnectException) {
                throw new ServiceUnavailableException("Mule Agent REST service is not available", e);
            }
            if (e.getCause() instanceof SocketTimeoutException) {
                throw new TimeoutException("Mule Agent REST service timed out", (Throwable)e);
            }
            throw new ToolingException(errorMessage, (Throwable)e);
        }
    }

    @Override
    public void disposeDomainMetadataCache(String domainId, String hashKey) {
        if (this.logger.isDebugEnabled()) {
            this.logger.debug("DELETE:tooling/domains/{}/cache/{}", (Object)domainId, (Object)hashKey);
        }
        this.doDisposeMetadataCache(() -> {
            this.client.tooling.domains.domainId((String)domainId).cache.hashKey(hashKey).delete(VERBOSE_ERROR_ENABLED);
            return null;
        }, this.createDescription("disposeDomainMetadataCache"), "Error while disposing Metadata");
    }

    @Override
    public void enableMessageHistory(String applicationName) throws NoSuchApplicationException {
        if (this.logger.isDebugEnabled()) {
            this.logger.debug("PUT:tooling/applications/{}/messagehistory/", (Object)applicationName);
        }
        try {
            this.client.tooling.applications.applicationName((String)applicationName).messageHistory.put(VERBOSE_ERROR_ENABLED, this.defaultReadTimeout);
        }
        catch (ToolingServiceAPIException e) {
            ErrorCode errorCode = e.getErrorCode();
            if (errorCode == ErrorCode.NO_SUCH_APPLICATION) {
                throw new NoSuchApplicationException("Application resource not found", (Exception)e);
            }
            throw new ToolingException("Error while enabling application for message history", (Throwable)e);
        }
        catch (Exception e) {
            if (e.getCause() instanceof ConnectException) {
                throw new ServiceUnavailableException("Mule Agent REST service is not available", e);
            }
            if (e.getCause() instanceof SocketTimeoutException) {
                throw new TimeoutException("Mule Agent REST service timed out", (Throwable)e);
            }
            throw new ToolingException("Error while enabling application for message history", (Throwable)e);
        }
    }

    @Override
    public List<AgentTrackingNotificationResponse> consumeMessageHistoryNotifications(String applicationName, int chunkSize) {
        if (this.logger.isDebugEnabled()) {
            this.logger.debug("GET:tooling/applications/{}/messagehistory/", (Object)applicationName);
        }
        try {
            return this.client.tooling.applications.applicationName((String)applicationName).messageHistory.get(chunkSize, VERBOSE_ERROR_ENABLED, this.defaultReadTimeout);
        }
        catch (ToolingServiceAPIException e) {
            ErrorCode errorCode = e.getErrorCode();
            if (errorCode == ErrorCode.NO_SUCH_APPLICATION) {
                throw new NoSuchApplicationException("Application resource not found", (Exception)e);
            }
            throw new ToolingException("Error while getting application notifications for MessageHistory", (Throwable)e);
        }
        catch (Exception e) {
            if (e.getCause() instanceof ConnectException) {
                throw new ServiceUnavailableException("Mule Agent REST service is not available", e);
            }
            if (e.getCause() instanceof SocketTimeoutException) {
                throw new TimeoutException("Mule Agent REST service timed out", (Throwable)e);
            }
            throw new ToolingException("Error while getting application notifications for MessageHistory", (Throwable)e);
        }
    }

    @Override
    public void disableMessageHistory(String applicationName) {
        if (this.logger.isDebugEnabled()) {
            this.logger.debug("DELETE:tooling/applications/{}/messagehistory/", (Object)applicationName);
        }
        try {
            this.client.tooling.applications.applicationName((String)applicationName).messageHistory.delete(VERBOSE_ERROR_ENABLED, this.defaultReadTimeout);
        }
        catch (Exception e) {
            if (e.getCause() instanceof ConnectException) {
                throw new ServiceUnavailableException("Mule Agent REST service is not available", e);
            }
            if (e.getCause() instanceof SocketTimeoutException) {
                throw new TimeoutException("Mule Agent REST service timed out", (Throwable)e);
            }
            throw new ToolingException("Error while disabling application for MessageHistory", (Throwable)e);
        }
    }

    @Override
    public ValueResult getValuesApplication(String applicationId, String location, String providerName) {
        if (this.logger.isDebugEnabled()) {
            this.logger.debug("GET:tooling/applications/{}/components/{}/valueProviders/{}", new Object[]{applicationId, location, providerName});
        }
        try {
            return ServiceFunction.serviceCallWrapper(() -> this.client.tooling.applications.applicationId((String)applicationId).components.componentId((String)location).valueProviders.get(providerName, this.defaultReadTimeout), this.createDescription("getValues(application"));
        }
        catch (Exception e) {
            if (e.getCause() instanceof ConnectException) {
                throw new ServiceUnavailableException("Mule Agent REST service is not available", e);
            }
            if (e.getCause() instanceof SocketTimeoutException) {
                throw new TimeoutException("Mule Agent REST service timed out", (Throwable)e);
            }
            throw new ToolingException(String.format("Error while trying to resolve Values for the ValueProvider [%s] located in [%s] of the application with ID [%s]", providerName, location, applicationId), (Throwable)e);
        }
    }

    @Override
    public ValueResult getValuesDomain(String domainId, String location, String providerName) {
        if (this.logger.isDebugEnabled()) {
            this.logger.debug("GET:tooling/domains/{}/components/{}/valueProviders/{}", new Object[]{domainId, location, providerName});
        }
        try {
            return ServiceFunction.serviceCallWrapper(() -> this.client.tooling.domains.domainId((String)domainId).components.componentId((String)location).valueProviders.get(providerName, this.defaultReadTimeout), this.createDescription("getValues(domain)"));
        }
        catch (Exception e) {
            if (e.getCause() instanceof ConnectException) {
                throw new ServiceUnavailableException("Mule Agent REST service is not available", e);
            }
            if (e.getCause() instanceof SocketTimeoutException) {
                throw new TimeoutException("Mule Agent REST service timed out", (Throwable)e);
            }
            throw new ToolingException(String.format("Error while trying to resolve Values for the ValueProvider [%s] located in [%s] of the domain with ID [%s]", providerName, location, domainId), (Throwable)e);
        }
    }

    public String toString() {
        return String.format("%s{url=%s}", ClassUtils.getShortClassName(this.getClass()), this.url);
    }
}

