/*
 * Copyright (c) MuleSoft, Inc.  All rights reserved.  http://www.mulesoft.com
 * The software in this package is published under the terms of the CPAL v1.0
 * license, a copy of which has been included with this distribution in the
 * LICENSE.txt file.
 */

package org.mule.tooling.agent.rest.client;

import org.mule.tooling.client.test.RuntimeType;

import java.io.File;
import java.io.InputStream;

import io.qameta.allure.Feature;
import io.qameta.allure.Story;

@Feature("Remote Runtime Tooling Service - Application deployment endpoints using deployment properties")
@Story("DeployToolingArtifact")
public class DeployApplicationWithDeploymentPropertiesTestCase extends DeployApplicationTestCase {

  public DeployApplicationWithDeploymentPropertiesTestCase(RuntimeType runtimeType) {
    super(runtimeType);
  }

  protected String doDeployDomain(File location) {
    return restAgentToolingService.deployDomain(location, getDeploymentProperties());
  }

  protected String doDeployDomain(InputStream inputStream) {
    return restAgentToolingService.deployDomain(inputStream, getDeploymentProperties());
  }

  protected String doDeployApplication(File emailAppLocation) {
    return restAgentToolingService.deployApplication(emailAppLocation, getDeploymentProperties());
  }

  protected String doDeployApplication(File location, String domainId) {
    return restAgentToolingService.deployApplication(location, domainId, getDeploymentProperties());
  }

  protected String doDeployApplication(InputStream inputStream) {
    return restAgentToolingService.deployApplication(inputStream, getDeploymentProperties());
  }

  protected String doDeployApplication(InputStream inputStream, String domainId) {
    return restAgentToolingService.deployApplication(inputStream, domainId, getDeploymentProperties());
  }

}
