/*
 * Copyright (c) MuleSoft, Inc.  All rights reserved.  http://www.mulesoft.com
 * The software in this package is published under the terms of the CPAL v1.0
 * license, a copy of which has been included with this distribution in the
 * LICENSE.txt file.
 */

package org.mule.tooling.agent.rest.client;

import org.mule.tooling.client.test.RuntimeType;

import java.io.File;
import java.io.InputStream;

import io.qameta.allure.Feature;
import io.qameta.allure.Story;

@Feature("Remote Runtime Tooling Service - Domain deployment endpoints using deployment properties")
@Story("DeployToolingArtifact")
public class DeployDomainWithDeploymentPropertiesTestCase extends DeployDomainTestCase {

  public DeployDomainWithDeploymentPropertiesTestCase(RuntimeType runtimeType) {
    super(runtimeType);
  }

  @Override
  protected String doDeployDomain(File domainLocation) {
    return restAgentToolingService.deployDomain(domainLocation, getDeploymentProperties());
  }

  @Override
  protected String doDeployDomain(InputStream inputStream) {
    return restAgentToolingService.deployDomain(inputStream, getDeploymentProperties());
  }

}
