/*
 * Copyright (c) MuleSoft, Inc.  All rights reserved.  http://www.mulesoft.com
 * The software in this package is published under the terms of the CPAL v1.0
 * license, a copy of which has been included with this distribution in the
 * LICENSE.txt file.
 */
package org.mule.tooling.agent.rest.client;

import static com.github.tomakehurst.wiremock.client.WireMock.aResponse;
import static com.github.tomakehurst.wiremock.client.WireMock.equalToIgnoreCase;
import static com.github.tomakehurst.wiremock.client.WireMock.get;
import static com.github.tomakehurst.wiremock.client.WireMock.urlPathMatching;
import static com.github.tomakehurst.wiremock.core.WireMockConfiguration.wireMockConfig;
import static java.util.Optional.empty;
import static java.util.Optional.of;
import static org.hamcrest.collection.IsCollectionWithSize.hasSize;
import static org.hamcrest.core.IsEqual.equalTo;
import static org.junit.Assert.assertThat;
import org.mule.tck.junit4.rule.DynamicPort;
import org.mule.tooling.agent.rest.client.api.ToolingServiceAPIClient;
import org.mule.tooling.agent.rest.client.tooling.applications.model.ApplicationsGETResponse;
import org.mule.tooling.client.api.configuration.agent.proxy.ProxyConfig;

import com.github.tomakehurst.wiremock.common.ConsoleNotifier;
import com.github.tomakehurst.wiremock.junit.WireMockClassRule;

import java.util.List;
import java.util.function.Consumer;

import org.junit.Rule;
import org.junit.Test;

public class AgentRestClientProxyTestCase {

  @Rule
  public WireMockClassRule proxyMockHttpRule =
      new WireMockClassRule(wireMockConfig().dynamicPort().notifier(new ConsoleNotifier(true)));
  @Rule
  public DynamicPort agentMockPort = new DynamicPort("agentMockPort");

  private void runTestWithHttpReturnBody(String body, Consumer<List<ApplicationsGETResponse>> validateResult) {
    proxyMockHttpRule.stubFor(get(urlPathMatching("/mule/applications")).withQueryParam("verbose", equalToIgnoreCase("false"))
        .willReturn(aResponse()
            .withStatus(200)
            .withHeader("Content-Type", "application/json")
            .withBody(body)));

    ToolingServiceAPIClient client =
        ToolingServiceAPIClient.create("http://localhost:" + agentMockPort.getValue() + "/mule",
                                       0,
                                       0,
                                       empty(), of(ProxyConfig.builder()
                                           .host("localhost")
                                           .port(proxyMockHttpRule.port())
                                           .build()));

    List<ApplicationsGETResponse> applications =
        client.tooling.applications.get(false, -1);

    validateResult.accept(applications);
  }

  @Test
  public void checkProxyHttp() {
    runTestWithHttpReturnBody("[{\"applicationId\": \"1234\"}]",
                              applicationsGETResponses -> {
                                assertThat(applicationsGETResponses, hasSize(1));
                                assertThat(applicationsGETResponses.get(0).getApplicationId(), equalTo("1234"));
                              });
  }

}
