/*
 * Copyright (c) MuleSoft, Inc.  All rights reserved.  http://www.mulesoft.com
 * The software in this package is published under the terms of the CPAL v1.0
 * license, a copy of which has been included with this distribution in the
 * LICENSE.txt file.
 */

package org.mule.tooling.agent.rest.client;

import static java.util.Collections.singletonMap;
import org.mule.tck.junit4.rule.DynamicPort;
import org.mule.tooling.client.test.RuntimeType;

import com.icegreen.greenmail.util.GreenMail;
import com.icegreen.greenmail.util.ServerSetup;

import java.util.Map;

import org.junit.Rule;

public abstract class AbstractDeploymentTestCase extends AbstractRestAgentToolingServiceTestCase {

  private static final String MAIL_SERVER_PORT_ARG = "emailServerPort";
  @Rule
  public DynamicPort emailServerPort = new DynamicPort("emailServerPort");

  protected GreenMail greenMail;

  public AbstractDeploymentTestCase(RuntimeType runtimeType) {
    super(runtimeType);
  }

  protected Map<String, String> getDeploymentProperties() {
    return singletonMap(MAIL_SERVER_PORT_ARG, emailServerPort.getValue());
  }

  protected void setUpEmailServer() {
    ServerSetup serverSetup = new ServerSetup(emailServerPort.getNumber(), null, "pop3");
    greenMail = new GreenMail(serverSetup);
    greenMail.setUser("foo", "pwd");
    greenMail.start();
  }

  protected void stopEmailServer() {
    if (greenMail != null) {
      greenMail.stop();
    }
  }

}
