/*
 * Copyright (c) MuleSoft, Inc.  All rights reserved.  http://www.mulesoft.com
 * The software in this package is published under the terms of the CPAL v1.0
 * license, a copy of which has been included with this distribution in the
 * LICENSE.txt file.
 */

package org.mule.tooling.agent.rest.client.service;

import static java.lang.System.currentTimeMillis;
import static org.slf4j.LoggerFactory.getLogger;

import java.util.function.Supplier;

import org.slf4j.Logger;

/**
 * Utility class to log invocations to external services.
 */
public class ServiceFunction {

  private static final Logger LOGGER = getLogger(ServiceFunction.class);

  public static <OutputType> OutputType serviceCallWrapper(Supplier<OutputType> function, String description) {
    long initialTime = currentTimeMillis();
    try {
      OutputType outputValue = function.get();
      long totalTimeSpent = currentTimeMillis() - initialTime;
      LOGGER.info(String.format("Calling service successfully: %s, executionTime: %s ms", description, totalTimeSpent));
      return outputValue;
    } catch (Exception e) {
      long totalTimeSpent = currentTimeMillis() - initialTime;
      LOGGER.info(String.format("Calling service failure: %s, executionTime: %s ms", description, totalTimeSpent));
      throw e;
    }
  }

}
