/*
 * Copyright (c) MuleSoft, Inc.  All rights reserved.  http://www.mulesoft.com
 * The software in this package is published under the terms of the CPAL v1.0
 * license, a copy of which has been included with this distribution in the
 * LICENSE.txt file.
 */
package org.mule.tooling.agent.rest.client;

import static org.hamcrest.core.IsEqual.equalTo;
import static org.junit.Assert.assertThat;
import static org.mule.tooling.agent.rest.client.VersionUtils.isVersionGreaterOrEqualThan;

import org.junit.Test;

public class VersionUtilsTestCase {

  @Test
  public void compareSnapshotVsRelease() {
    assertThat(isVersionGreaterOrEqualThan("4.1.5-SNAPSHOT", "4.1.5"), equalTo(false));
  }

  @Test
  public void compareReleaseVsSnapshot() {
    assertThat(isVersionGreaterOrEqualThan("4.1.4", "4.1.5-SNAPSHOT"), equalTo(false));
    assertThat(isVersionGreaterOrEqualThan("4.1.5", "4.1.5-SNAPSHOT"), equalTo(true));
    assertThat(isVersionGreaterOrEqualThan("4.1.6", "4.1.5-SNAPSHOT"), equalTo(true));
  }

  @Test
  public void compareSnapshotVsSnapshot() {
    assertThat(isVersionGreaterOrEqualThan("4.1.4-SNAPSHOT", "4.1.5-SNAPSHOT"), equalTo(false));
    assertThat(isVersionGreaterOrEqualThan("4.1.5-SNAPSHOT", "4.1.5-SNAPSHOT"), equalTo(true));
    assertThat(isVersionGreaterOrEqualThan("4.1.6-SNAPSHOT", "4.1.5-SNAPSHOT"), equalTo(true));
  }
}
