/*
 * Decompiled with CFR 0.152.
 */
package org.mule.tooling.agent.rest.client.exceptions.model;

import java.util.HashMap;
import java.util.Map;

public enum ErrorCode {
    NO_SUCH_APPLICATION,
    BUNDLE_NOT_FOUND,
    CONNECTIVITY_TESTING_OBJECT_NOT_FOUND,
    UNSUPPORTED_CONNECTIVITY_TESTING_OBJECT,
    UNKNOWN_ERROR;

    private static final Map<String, ErrorCode> mapping;

    public static ErrorCode get(String errorType) {
        if (!mapping.containsKey(errorType)) {
            return UNKNOWN_ERROR;
        }
        return mapping.get(errorType);
    }

    static {
        mapping = new HashMap<String, ErrorCode>();
        mapping.put("class com.mulesoft.agent.exception.NoSuchApplicationException", NO_SUCH_APPLICATION);
        mapping.put("class org.mule.runtime.module.repository.api.BundleNotFoundException", BUNDLE_NOT_FOUND);
        mapping.put("class org.mule.runtime.api.exception.ObjectNotFoundException", CONNECTIVITY_TESTING_OBJECT_NOT_FOUND);
        mapping.put("class org.mule.runtime.api.connectivity.UnsupportedConnectivityTestingObjectException", UNSUPPORTED_CONNECTIVITY_TESTING_OBJECT);
    }
}

