/*
 * Decompiled with CFR 0.152.
 */
package org.mule.tooling.agent.rest.client.tooling.applications.applicationId.components.componentId.connection;

import com.mulesoft.agent.external.handlers.tooling.TestConnectionRequest;
import com.mulesoft.agent.external.handlers.tooling.serialization.TestConnectionRequestSerializer;
import javax.ws.rs.client.Client;
import javax.ws.rs.client.Entity;
import javax.ws.rs.client.Invocation;
import javax.ws.rs.client.WebTarget;
import javax.ws.rs.core.MediaType;
import javax.ws.rs.core.Response;
import org.mule.tooling.agent.rest.client.exceptions.ToolingServiceAPIException;
import org.mule.tooling.agent.rest.client.tooling.applications.applicationId.components.componentId.connection.ConnectivityTestingResponseSerializer;
import org.mule.tooling.agent.rest.client.tooling.applications.applicationId.components.componentId.connection.model.ConnectivityTestingResponse;

public class Connection {
    private String baseUrl;
    private Client client;

    public Connection(String baseUrl, Client client) {
        this.baseUrl = baseUrl + "/connection";
        this.client = client;
    }

    private Client getClient() {
        return this.client;
    }

    private String getBaseUri() {
        return this.baseUrl;
    }

    public ConnectivityTestingResponse get(boolean verboseErrorsEnabled, int readTimeout) throws ToolingServiceAPIException {
        Invocation.Builder invocationBuilder = this.getBuilder(verboseErrorsEnabled, readTimeout);
        Response response = invocationBuilder.get();
        return this.readConnectivityTestingResponse(response);
    }

    public ConnectivityTestingResponse put(TestConnectionRequest request, boolean verboseErrorsEnabled, int readTimeout) throws ToolingServiceAPIException {
        Invocation.Builder invocationBuilder = this.getBuilder(verboseErrorsEnabled, readTimeout);
        Response response = invocationBuilder.put(Entity.json((Object)TestConnectionRequestSerializer.create().serialize(request)));
        return this.readConnectivityTestingResponse(response);
    }

    private ConnectivityTestingResponse readConnectivityTestingResponse(Response response) throws ToolingServiceAPIException {
        if (response.getStatusInfo().getFamily() != Response.Status.Family.SUCCESSFUL) {
            throw ToolingServiceAPIException.newToolingServiceAPIException(response);
        }
        return new ConnectivityTestingResponseSerializer().deserialize((String)response.readEntity(String.class));
    }

    private Invocation.Builder getBuilder(boolean verboseErrorsEnabled, int readTimeout) {
        WebTarget target = this.getClient().target(this.getBaseUri());
        target = target.queryParam("verbose", new Object[]{verboseErrorsEnabled});
        Invocation.Builder invocationBuilder = target.request(new MediaType[]{MediaType.APPLICATION_JSON_TYPE});
        if (readTimeout > 0) {
            invocationBuilder.property("jersey.config.client.readTimeout", (Object)readTimeout);
        }
        return invocationBuilder;
    }
}

