/*
 * Copyright (c) MuleSoft, Inc.  All rights reserved.  http://www.mulesoft.com
 * The software in this package is published under the terms of the CPAL v1.0
 * license, a copy of which has been included with this distribution in the
 * LICENSE.txt file.
 */
package org.mule.tooling.agent.rest.client;

import static com.github.tomakehurst.wiremock.client.WireMock.aResponse;
import static com.github.tomakehurst.wiremock.client.WireMock.get;
import static com.github.tomakehurst.wiremock.client.WireMock.urlPathMatching;
import static com.github.tomakehurst.wiremock.core.WireMockConfiguration.wireMockConfig;
import static java.util.Optional.empty;
import static org.hamcrest.collection.IsCollectionWithSize.hasSize;
import static org.hamcrest.core.Is.is;
import static org.hamcrest.core.IsEqual.equalTo;
import static org.junit.Assert.assertThat;
import org.mule.tooling.agent.rest.client.api.ToolingServiceAPIClient;
import org.mule.tooling.agent.rest.client.tooling.applications.applicationName.messageHistory.AgentTrackingNotificationResponse;

import com.github.tomakehurst.wiremock.junit.WireMockClassRule;

import java.util.List;
import java.util.function.Consumer;

import org.junit.Rule;
import org.junit.Test;

public class AgentRestClientSerializationTestCase {

  @Rule
  public WireMockClassRule wireMockRule = new WireMockClassRule(wireMockConfig().dynamicPort());

  private void runTestWithReturnBody(String body, Consumer<List<AgentTrackingNotificationResponse>> validateResult) {
    wireMockRule.stubFor(
                         get(urlPathMatching("/mule/applications/myapp/messagehistory([a-z]*)"))
                             .willReturn(aResponse()
                                 .withStatus(200)
                                 .withHeader("Content-Type", "application/json")
                                 .withBody(body)));
    int port = wireMockRule.port();

    ToolingServiceAPIClient client =
        ToolingServiceAPIClient.create("http://localhost:" + port + "/mule", 0, 0, empty(), empty());

    List<AgentTrackingNotificationResponse> agentTrackingNotificationResponses =
        client.tooling.applications.applicationName("myapp").messageHistory.get(-1, false, 0);

    validateResult.accept(agentTrackingNotificationResponses);
    assertThat(agentTrackingNotificationResponses, hasSize(1));
    assertThat(agentTrackingNotificationResponses.get(0).getApplication(), equalTo("myapp"));
  }

  @Test
  public void ignoreUnknownFields() {
    runTestWithReturnBody("[{\"application\": \"myapp\", \"thisPropertyDoesNotExist\": 1}]",
                          agentTrackingNotificationResponses -> {
                            assertThat(agentTrackingNotificationResponses, hasSize(1));
                            assertThat(agentTrackingNotificationResponses.get(0).getApplication(), equalTo("myapp"));
                          });
  }

  @Test
  public void ignoreUnknownNestedFields() {
    runTestWithReturnBody("["
        + "   {"
        + "       \"application\": \"myapp\","
        + "       \"event\": {"
        + "           \"thisPropertyDoesNotExist\": 1,"
        + "           \"successful\": \"true\""
        + "       }"
        + "   }"
        + "]", agentTrackingNotificationResponses -> {
          assertThat(agentTrackingNotificationResponses, hasSize(1));
          AgentTrackingNotificationResponse agentTrackingNotificationResponse = agentTrackingNotificationResponses.get(0);
          assertThat(agentTrackingNotificationResponse.getApplication(), equalTo("myapp"));
          assertThat(agentTrackingNotificationResponse.getEvent().isSuccessful(), is(true));
        });
  }

}
