/*
 * Copyright (c) MuleSoft, Inc.  All rights reserved.  http://www.mulesoft.com
 * The software in this package is published under the terms of the CPAL v1.0
 * license, a copy of which has been included with this distribution in the
 * LICENSE.txt file.
 */

package org.mule.tooling.agent.rest.client;

import static java.util.Collections.emptyMap;
import static java.util.Collections.singletonList;
import static org.apache.commons.lang3.tuple.ImmutablePair.of;
import org.mule.tooling.client.test.RuntimeType;

import java.io.File;
import java.io.InputStream;
import java.util.List;

import io.qameta.allure.Feature;
import io.qameta.allure.Story;
import org.apache.commons.lang3.tuple.ImmutablePair;

@Feature("Remote Runtime Tooling Service - Applications without deployment properties")
@Story("DeployToolingArtifact")
public class DeployApplicationWithoutDeploymentPropertiesTestCase extends DeployApplicationTestCase {

  public DeployApplicationWithoutDeploymentPropertiesTestCase(RuntimeType runtimeType) {
    super(runtimeType);
  }

  @Override
  protected void setMuleVersion(RestAgentToolingService restAgentToolingService) {
    restAgentToolingService.setMuleVersion(null);
  }

  @Override
  protected List<ImmutablePair<String, String>> getStartupSystemProperties() {
    return singletonList(of("emailServerPort", String.valueOf(emailServerPort.getNumber())));
  }

  protected String doDeployDomain(File location) {
    return restAgentToolingService.deployDomain(location, emptyMap());
  }

  protected String doDeployDomain(InputStream inputStream) {
    return restAgentToolingService.deployDomain(inputStream, emptyMap());
  }

  protected String doDeployApplication(File emailAppLocation) {
    return restAgentToolingService.deployApplication(emailAppLocation, emptyMap());
  }

  protected String doDeployApplication(File location, String domainId) {
    return restAgentToolingService.deployApplication(location, domainId, emptyMap());
  }

  protected String doDeployApplication(InputStream inputStream) {
    return restAgentToolingService.deployApplication(inputStream, emptyMap());
  }

  protected String doDeployApplication(InputStream inputStream, String domainId) {
    return restAgentToolingService.deployApplication(inputStream, domainId, emptyMap());
  }

}
