/*
 * Copyright (c) MuleSoft, Inc.  All rights reserved.  http://www.mulesoft.com
 * The software in this package is published under the terms of the CPAL v1.0
 * license, a copy of which has been included with this distribution in the
 * LICENSE.txt file.
 */
package org.mule.tooling.agent.rest.client;

import static java.util.Collections.emptyMap;
import static org.hamcrest.MatcherAssert.assertThat;
import static org.hamcrest.core.Is.is;
import static org.hamcrest.core.IsCollectionContaining.hasItems;
import static org.mule.tck.junit4.matcher.ValueMatcher.valueWithId;
import org.mule.runtime.api.component.location.Location;
import org.mule.runtime.api.value.ValueResult;
import org.mule.tooling.client.test.RuntimeType;

import java.io.File;
import java.net.URISyntaxException;

import io.qameta.allure.Description;
import io.qameta.allure.Feature;
import io.qameta.allure.Story;
import org.junit.Test;

@Feature("Remote Runtime Tooling Service")
@Story("Value Provider")
public class ValueProvidersTestCase extends AbstractRestAgentToolingServiceTestCase {

  public ValueProvidersTestCase(RuntimeType runtimeType) {
    super(runtimeType);
  }

  @Test
  @Description("Resolves the Values through the ValueProviderService for the ContentTransferEncoding parameter")
  public void getValueForEmailContentTransferEncoding() throws URISyntaxException {
    File targetTestClassesFolder = new File(this.getClass().getProtectionDomain().getCodeSource().getLocation().toURI());
    File emailAppLocation = new File(targetTestClassesFolder, "applications/value-providers");

    String applicationId = restAgentToolingService.deployApplication(emailAppLocation, emptyMap());
    String sendEmail = Location.builder().globalName("sendEmail").addProcessorsPart().addIndexPart(0).build().toString();

    ValueResult values = restAgentToolingService.getValuesApplication(applicationId, sendEmail, "contentTransferEncoding");

    assertThat(values.isSuccess(), is(true));
    assertThat(values.getValues(), is(hasItems(valueWithId("7BIT"), valueWithId("8BIT"), valueWithId("Base64"),
                                               valueWithId("Quoted-Printable"), valueWithId("Binary"))));
  }

  @Test
  @Description("Resolves the Values through the ValueProviderService for the ContentTransferEncoding parameter on an application that has a domain dependency")
  public void getValueForEmailContentTransferEncodingUsingDomain()
      throws URISyntaxException {
    File targetTestClassesFolder = new File(this.getClass().getProtectionDomain().getCodeSource().getLocation().toURI());
    File emailDomain = new File(targetTestClassesFolder, "domains/value-providers-domain");

    String domainId = restAgentToolingService.deployDomain(emailDomain, emptyMap());
    File emailAppLocation = new File(targetTestClassesFolder, "applications/value-providers-app");

    String applicationId = restAgentToolingService.deployApplication(emailAppLocation, domainId, emptyMap());
    String sendEmail = Location.builder().globalName("sendEmail").addProcessorsPart().addIndexPart(0).build().toString();

    ValueResult values = restAgentToolingService.getValuesApplication(applicationId, sendEmail, "contentTransferEncoding");

    assertThat(values.isSuccess(), is(true));
    assertThat(values.getValues(), is(hasItems(valueWithId("7BIT"), valueWithId("8BIT"), valueWithId("Base64"),
                                               valueWithId("Quoted-Printable"), valueWithId("Binary"))));
  }

}
